%define pypi_name pg_activity

%def_with check

Name:    python3-module-%pypi_name
Version: 3.5.1
Release: alt2.p10.1

Summary: Top like application for PostgreSQL server activity monitoring
License: PostgreSQL
Group:   Monitoring
URL:     https://pypi.org/project/pg-activity
VCS:     https://github.com/dalibo/pg_activity

Provides: pg_activity = %EVR
Provides: pg-activity = %EVR

%pyproject_runtimedeps_metadata
BuildRequires(pre):rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
%if_with check
BuildRequires: codespell
BuildRequires: python3(attrs)
BuildRequires: python3(blessed)
BuildRequires: python3(humanize)
BuildRequires: python3(mypy)
BuildRequires: python3(psutil)
BuildRequires: python3(psycopg)
BuildRequires: python3(psycopg2)
BuildRequires: python3(pytest)
BuildRequires: python3(typing_extensions)
BuildRequires: pkgconfig(libpq)
%endif

Requires: python3-module-psycopg2

BuildArch: noarch

Source0: %name-%version.tar
Source1: setuptools-68.2.2-py3-none-any.whl
Source2: %pyproject_deps_config_name

%description
%pypi_name is a top like application for PostgreSQL server activity monitoring.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
# build with bundled setuptools
mkdir dist
cp %SOURCE1 dist/
echo "$(basename '%SOURCE1')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDUNITTEST'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDUNITTEST

%install
%pyproject_install

%check
# XXX: Exclude tests which requires orphaned and early removed modules
export PYTHONPATH=%buildroot%python3_sitelibdir
%pyproject_run_pytest -k 'not test_data and not test_ui and not test_config'

%files
%doc *.md LICENSE.txt
%_bindir/%pypi_name
%python3_sitelibdir/pgactivity
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
