%define oname pycryptodome

Name:     python3-module-%oname
Version:  3.20.0
Release:  alt1

Summary:  A self-contained cryptographic library for Python

# The source code in PyCryptodome is partially in the public domain
# and partially released under the BSD 2-Clause license.
# In either case, there are minimal if no restrictions on the redistribution,
# modification and usage of the software.
License:  BSD-2-Clause
Group:    Development/Python3
URL:      https://pypi.org/project/pycryptodome
VCS:      https://github.com/Legrandin/pycryptodome

Packager: Grigory Ustinov <grenka@altlinux.org>

Source:   %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

Conflicts: python3-module-Crypto < %EVR
Conflicts: python3-module-pycrypto < %EVR
Obsoletes: python3-module-Crypto < %EVR
Obsoletes: python3-module-pycrypto < %EVR
Provides: python3-module-Crypto = %EVR
Provides: python3-module-pycrypto = %EVR
%py3_provides Crypto

%description
PyCryptodome is a self-contained Python package of low-level
cryptographic primitives.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
PyCryptodome is a self-contained Python package of low-level
cryptographic primitives.

This package contains tests for %oname.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
python3 -m Crypto.SelfTest

%files
%doc *.rst
%python3_sitelibdir/Crypto
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/SelfTest

%files tests
%python3_sitelibdir/*/SelfTest

%changelog
