%define oname pyftpdlib
%define descr \
Python FTP server library provides a high-level portable interface to easily \
write asynchronous FTP servers with Python. pyftpdlib is currently the most \
complete RFC-959 FTP server implementation available for Python programming \
language.

%def_with docs

Name: python3-module-%oname
Version: 1.5.6
Release: alt2

Summary: Python FTP server library
Summary(ru_RU.UTF-8): Модуль Python FTP-сервера

Group: Development/Python3
License: MIT and BSD
Url: https://github.com/giampaolo/pyftpdlib

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme
%endif

Conflicts: python-module-%oname < %EVR
Obsoletes: python-module-%oname < %EVR

BuildArch: noarch

%py3_provides %oname
%py3_requires sendfile

%description -l ru_RU.UTF-8
Модуль Python FTP-сервера беспечивает портативный высокоуровневый интерфейс
для лёгкого написания асинхронного FTP сервера на Python. pyftpdlib сейчас --
наиболее полная реализация RFC-959 FTP-сервера для Python.

%description
%descr

%package tests
Summary: Documentation for %oname
Group: Development/Python3
%py3_requires %oname

%description tests
%descr

This package contains tests for %oname.

%if_with docs
%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
%descr

This package contains documentation for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
%descr

This package contains pickles for %oname.
%endif

%prep
%setup

sed -i -e "s|^__ver__ = '[^']*'|__ver__ = '%version'|" pyftpdlib/__init__.py

%if_with docs
sed -i "s/= python/= python3/" docs/Makefile

%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%python3_build

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs pickle
%make -C docs html
%make -C docs man
%endif

%install
%python3_install

%if_with docs
mkdir -p %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname
mkdir -p %buildroot%_man1dir
cp -fR docs/_build/man/* %buildroot%_man1dir
%endif

%files
%doc CREDITS LICENSE *.rst demo/
%_bindir/*
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-info*
%exclude %python3_sitelibdir/%oname/test
%if_with docs
%_man1dir/*
%exclude %python3_sitelibdir/%oname/pickle
%endif

%files tests
%python3_sitelibdir/%oname/test
%exclude %python3_sitelibdir/%oname/test/README

%if_with docs
%files docs
%doc docs/_build/html/*

%files pickles
%python3_sitelibdir/%oname/pickle
%endif

%changelog
