%define _unpackaged_files_terminate_build 1

%define oname pysndfile

Name: python3-module-%oname
Version: 1.1.0
Release: alt3

Summary: Cython wrapper class for reading/writing soundfiles using libsndfile
License: LGPLv3
Group: Development/Python3
Url: https://pypi.python.org/pypi/pysndfile/

Source: %oname-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ libsndfile-devel
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3-module-Cython libnumpy-py3-devel
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-html5lib python3-module-notebook

%description
pysndfile is a python package providing PySndfile, a Cython wrapper
class around libsndfile. PySndfile provides methods for reading and
writing a large variety of soundfile formats on a variety of plattforms.
PySndfile provides a rather complete access to the different sound file
manipulation options that are available in libsndfile.

Due to the use of libsndfile nearly all sound file formats, (besides mp3
and derived formats) can be read and written with PySndfile.

%prep
%setup -n %oname-%version

rm -f *.cpp

%build
%python3_build_debug

%install
%python3_install

%check
export CFLAGS="%optflags"
export CXXFLAGS="%optflags"
export FFLAGS="%optflags"

%__python3 setup.py test
PYTHONPATH=%buildroot%python3_sitelibdir python3 tests/pysndfile_test.py

%files
%doc ChangeLog README.*
%python3_sitelibdir/*


%changelog
