%define _unpackaged_files_terminate_build 1
%define pypi_name pytest-django

%def_with check

Name: python3-module-%pypi_name
Version: 4.5.2
Release: alt2

Summary: A Django plugin for py.test

License: BSD
Group: Development/Python3
Url: https://pypi.org/project/pytest-django/

# https://github.com/pytest-dev/pytest-django.git
BuildArch: noarch

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(setuptools_scm)

%if_with check
# install_requires=
BuildRequires: python3(pytest)

BuildRequires: python3-module-django
BuildRequires: python3-module-django-dbbackend-sqlite3
BuildRequires: python3(pytest-xdist)
%endif

%py3_provides %pypi_name

# we have several versions of Django
# so, we cannot rely on auto-requires
%filter_from_requires /^python3(django\(\..*\)\?)/d

%description
pytest-django allows you to test your Django project/applications with
the pytest testing tool.

%prep
%setup
%autopatch -p1

# setuptools_scm implements a file_finders entry point which returns all files
# tracked by SCM.
if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag '%version'
fi

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc AUTHORS *.rst
%python3_sitelibdir/pytest_django/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
