%define _unpackaged_files_terminate_build 1
%define pypi_name pytest-ignore-flaky
%define mod_name pytest_ignore_flaky

%def_with check

Name: python3-module-%pypi_name
Version: 2.2.1
Release: alt0.p10.1
Summary: Ignore failures from flaky tests
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pytest-ignore-flaky
Vcs: https://github.com/schettino72/pytest-ignore-flaky
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: setuptools-68.2.2-py3-none-any.whl
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra testing
%endif

%description
Ignore failures from flaky tests (pytest plugin).

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
# https://bugzilla.altlinux.org/47647
mkdir dist
cp %SOURCE2 dist/
echo "$(basename '%SOURCE2')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDRUN'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_deps_resync_metadata
%define __python3 %__python3_orig
ENDRUN

%build
%pyproject_run -- bash -s <<-'ENDRUN'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDRUN

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
