%define _unpackaged_files_terminate_build 1
%define oname pytest-multihost

%def_with check

Name: python3-module-%oname
Version: 3.4
Release: alt1

Summary: Utility for writing multi-host tests for pytest
License: GPLv3
Group: Development/Python3
# Source-git: https://github.com/encukou/pytest-multihost.git
Url: https://pypi.python.org/pypi/pytest-multihost

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(paramiko)
BuildRequires: python3(tox)
%endif

%set_python3_req_method strict
%py3_provides pytest-multihost

BuildArch: noarch

%description
A pytest plugin for multi-host testing.

%prep
%setup
# skip tests which require SSH connection
sed -i '/commands = python -m pytest/s/$/ -m "not needs_ssh"/g' tox.ini

%build
%python3_build

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -v

%files
%doc README.rst COPYING
%python3_sitelibdir/pytest_multihost/
%python3_sitelibdir/pytest_multihost-*.egg-info/

%changelog
