%define _unpackaged_files_terminate_build 1
%define oname python_utils

%def_with check

Name: python3-module-%oname
Version: 2.5.6
Release: alt1

Summary: A module with some convenient utilities not included with the standard Python install
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/python-utils/

BuildArch: noarch

# https://github.com/WoLpH/python-utils.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest-runner

%if_with check
# install_requires:
BuildRequires: python3(six)

BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
%endif

%py3_provides python-utils

%description
Python Utils is a collection of small Python functions and classes which
make common patterns shorter and easier. It is by no means a complete
collection but it has served me quite a bit in the past and I will keep
extending it.

%prep
%setup
%autopatch -p1

%build
%python3_build_debug

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages --no-deps --console-scripts -vvr -s false

%files
%doc *.rst
%python3_sitelibdir/python_utils/
%python3_sitelibdir/python_utils-%version-py%_python3_version.egg-info/

%changelog
