%define modname pyvfs

Name: python3-module-%modname
Version: 0.2.10
Release: alt2

Summary: Simple python VFS library
License: GPLv3+
Group: Development/Python3
URL: https://github.com/svinota/pyvfs
BuildArch: noarch

Source: pyvfs-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-objects.inv python3-module-sphinx

Requires: python3-module-py9p >= 1.0.6-alt1


%description
PyVFS is a simple VFS library written in Python. It consists of
several layers, allowing to use different low-level protocol
implementations. Now you can choose between 9p (9p2000.u) and
FUSE.

The library can be used to create own servers as well as deploy
bundled applications, e.g. pyvfs.objectfs -- the library, that allows
to represent Python objects as files.

%prep
%setup -n pyvfs-%version

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
make force-version
%python3_build

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html
mkdir man
cp -fR docs/_build/html/* man/

%install
%python3_install

%files
%doc README* LICENSE man/
%python3_sitelibdir/*


%changelog
