%define _unpackaged_files_terminate_build 1
%define oname pyvista

Name: python3-module-%oname
Version: 0.42.3
Release: alt0.p10.1
Summary: 3D plotting and mesh analysis through a streamlined interface for the Visualization Toolkit (VTK)
License: MIT
Group: Development/Python3
Url: https://docs.pyvista.org/version/stable/index.html
VCS: https://github.com/pyvista/pyvista.git

BuildArch: noarch

Source: %name-%version.tar
Source1: setuptools-68.2.2-py3-none-any.whl

BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-vtk
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-pooch
BuildRequires: python3-module-scooby
BuildRequires: python3-module-matplotlib
# Optional requirement for jupyter web integration
%filter_from_requires /python3(trame\(\..*\)\?)/d
%filter_from_requires /python3(trame_vtk\(\..*\)\?)/d

%description
PyVista is a helper module for the Visualization Toolkit (VTK) that
wraps the VTK library through NumPy and direct array access through a
variety of methods and classes.

%prep
%setup

%build
# https://bugzilla.altlinux.org/47647
# build with bundled setuptools
mkdir dist
cp %SOURCE1 dist/
echo "$(basename '%SOURCE1')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDUNITTEST'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDUNITTEST

%install
%pyproject_install

%files
%doc LICENSE README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
