%define oname repoze.configuration

Name: python3-module-%oname
Version: 0.9
Release: alt3

Summary: Extensible, YAML-based configuration for Python applications
License: BSD
Group: Development/Python3
Url: https://github.com/repoze/repoze.configuration

# https://github.com/repoze/repoze.configuration.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python-tools-2to3

%py3_requires repoze yaml


%description
``repoze.configuration`` is a package that software developers can use
as a configuration system.  It allows the use of ``YAML`` as a
configuration language.  Application-defined "directives" can be
plugged in to ``repoze.configuration`` using one or more Python
setuptools entry points.

%package tests
Summary: Tests for repoze.configuration
Group: Development/Python3
Requires: %name = %version-%release

%description tests
``repoze.configuration`` is a package that software developers can use
as a configuration system.  It allows the use of ``YAML`` as a
configuration language.  Application-defined "directives" can be
plugged in to ``repoze.configuration`` using one or more Python
setuptools entry points.

This package contains tests for repoze.configuration.

%prep
%setup

find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' +

%build
%python3_build

%install
%python3_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
    %buildroot%python3_sitelibdir/
%endif

%files
%doc *.txt docs/*.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests


%changelog
