%define _unpackaged_files_terminate_build 1
%define oname requests-mock

%def_with check

Name: python3-module-%oname
Version: 1.8.0
Release: alt1
Summary: Mock out responses from the requests package
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/requests-mock/

Source: %name-%version.tar
Patch0: %name-%version-alt.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(pbr)

%if_with check
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(pytest)
BuildRequires: python3(requests)
BuildRequires: python3(purl)
BuildRequires: python3(urllib3)
BuildRequires: python3(testrepository)
%endif

%py3_provides %oname

%description
The requests-mock library at its core is simply a transport adapter that
can be preloaded with responses that are returned if certain URIs are
requested. This is particularly useful in unit tests where you want to
return known responses from HTTP requests without making actual calls.

As the requests library has very limited options for how to load and use
adapters requests-mock also provides a number of ways to make sure the
mock adapter is used. These are only loading mechanisms, they do not
contain any logic and can be used as a reference to load the adapter in
whatever ways works best for your project.

%prep
%setup
%autopatch -p1

%build
export PBR_VERSION=%version
%python3_build

%install
export PBR_VERSION=%version
%python3_install

%check
export PBR_VERSION=%version
export PIP_NO_INDEX=YES
export TOXENV=py3
export TOX_TESTENV_PASSENV='PBR_VERSION'
tox.py3 --sitepackages --console-scripts --no-deps -vvr

%files
%doc *.rst
%python3_sitelibdir/*

%changelog
