%define _unpackaged_files_terminate_build 1

%def_without tests

%define modname scipy
%define ver_major 1.6
%define ver_minor 1

%define numpy_version 1.16.5

Name: python3-module-%modname
Version: %ver_major.%ver_minor
Release: alt3.p10.1
Summary: SciPy is the library of scientific codes
License: BSD-3-Clause
Group: Development/Python3
Url: https://www.scipy.org/

#VCS git://github.com/scipy/scipy.git
Source: %name-%version.tar
Source1: site.cfg

BuildRequires(pre): rpm-macros-make
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ gcc-fortran liblapack-devel
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel python3-module-numpy-testing
BuildRequires: python3-module-Cython
BuildRequires: python3-module-html5lib
BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-pybind11

Requires: %python3_sitelibdir_noarch
Requires: python3-module-numpy >= %numpy_version
%add_python3_req_skip _min_spanning_tree _shortest_path _tools
%add_python3_req_skip _traversal sympy
%add_python3_req_skip distutils
%if_with tests
%add_python3_req_skip scipy.fft.tests
%else
%add_python3_req_skip numpy.testing
%endif

%description
SciPy is the library of scientific codes built on top of NumPy.

%package devel
Summary: Development files of SciPy (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-devel
Requires: libnumpy-py3-devel

%description devel
SciPy is the library of scientific codes built on top of NumPy.

This package contains development files of SciPy.

%prep
%setup
install -p -m644 %SOURCE1 .
sed -i 's|@LIBDIR@|%_libdir|g' site.cfg doc/Makefile
sed -i 's|@PYVER@|%_python_version|g' doc/Makefile
sed -i 's|@PYSUFF@|3|' site.cfg

%if_without tests
# Find and comment out Pytest imports, since main package should
# not require test deps
grep -zPqsr '[ ]*from scipy._lib._testutils import PytestTester\n[ ]*test = PytestTester\(__name__\)\n[ ]*del PytestTester\n' || exit 1
grep -zPrl '[ ]*from scipy._lib._testutils import PytestTester\n[ ]*test = PytestTester\(__name__\)\n[ ]*del PytestTester\n' | xargs \
sed -i '/from scipy._lib._testutils import PytestTester/,/del PytestTester/ {s/^/# /}'
%endif

mkdir -p ~/.matplotlib
cp %python3_sitelibdir/matplotlib/mpl-data/matplotlibrc \
	~/.matplotlib/
sed -i 's|^\(backend\).*|\1 : Agg|' ~/.matplotlib/matplotlibrc

%build
%add_optflags -I%_includedir/suitesparse -fno-strict-aliasing %optflags_shared
%python3_build_debug build_ext build_py build_clib \
	config_fc --fcompiler=gnu95

%install
%python3_install install_lib install_headers \
	install_data config_fc
find %buildroot%python3_sitelibdir -type f -exec \
	sed -i 's|#! %_bindir/env python|#!%_bindir/python3|' -- '{}' + ||:
find %buildroot%python3_sitelibdir -type f -exec \
	sed -i 's|#!%_bindir/env python|#!%_bindir/python3|' -- '{}' + ||:

# headers
pushd %modname
for i in $(find ./ -name '*.h'); do
    dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
    install -d %buildroot%_includedir/%modname-py3/$dir
    install -p -m644 $i \
	%buildroot%_includedir/%modname-py3/$dir
done
popd

install -p -m644 $(find ./ -name fortranobject.h | head -n 1) \
	%buildroot%_includedir/%modname-py3
pushd %buildroot%python3_sitelibdir/%modname/sparse/csgraph
for i in $(ls *.so); do
	ln -s %python3_sitelibdir/%modname/sparse/csgraph/$i \
		%buildroot%python3_sitelibdir/
done
popd

%if_without tests
# don't package tests and tests' data
for i in $(find %buildroot%python3_sitelibdir \
               -name tests -type d \
               -o -name 'conftest.*' -type f \
               -o -name '_testutils.*' -type f \
               -o -name 'gammainc_data.*' -type f \
               -o -name '_mptestutils.*' -type f)
do
	rm -r "$i"
done
%endif

%find_lang %name

#check
#pushd %buildroot%python_sitelibdir
#python -c "import scipy ; scipy.test()"
#popd
#rm -f %buildroot%python_sitelibdir/*.so \
#	%buildroot%python_sitelibdir/*.cpp

%files -f %name.lang
%python3_sitelibdir/*

%files devel
%_includedir/%modname-py3

%changelog
