%define oname selectors2
%def_without test

Name: python3-module-selectors2
Version: 2.0.2
Release: alt1

Summary: Back-ported, durable, and portable selectors

License: MIT
Group: Development/Python3
Url: https://pypi.org/project/selectors2/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools

%if_with test
# generated by epm --restore --dry-run from python3-module-selectors2/dev-requirements.txt
%py3_buildrequires check-manifest >= 0.36
%py3_buildrequires nose >= 1.3.7
%py3_buildrequires psutil >= 5.2.2
%py3_buildrequires readme-renderer >= 17.2
%py3_buildrequires mock >= 2.0.0
%endif

%description
Backported, durable, and portable selectors designed to replace the standard library selectors module.

This module is a 1-to-1 drop-in replacement for selectors and provides all selector types
that would be available in selectors including DevpollSelector, KqueueSelector, EpollSelector, PollSelector, and SelectSelector.

This module is similar to selectors34 in that it supports Python 2.6 - 3.3 but differs in that this module
also implements PEP 475 for the backported selectors.
This allows similar behaviour between Python 3.5+ selectors and selectors from before PEP 475.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install
%python3_prune

%if_with test
%check
%python3_test
%endif

%files
%doc README.rst CHANGELOG.rst
%python3_sitelibdir/*

%changelog
