%define _unpackaged_files_terminate_build 1
%define mname setuptools
%define system_wheels_path %(%__python3 -c 'import os, sys, system_seed_wheels; sys.stdout.write(os.path.dirname(system_seed_wheels.__file__))')

%def_with check
%def_without bootstrap

Name: python3-module-%mname
Epoch: 1
Version: 57.4.0
Release: alt2.p10.1

Summary: Easily download, build, install, upgrade, and uninstall Python packages
License: MIT
Group: Development/Python3
# Source-git: https://github.com/pypa/setuptools.git
Url: https://pypi.org/project/setuptools/

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: /dev/shm
BuildRequires: python3(mock)
BuildRequires: python3(jaraco.envs)
BuildRequires: python3(jaraco.path)
BuildRequires: python3(pip)
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_xdist)
BuildRequires: python3(pytest_timeout)
BuildRequires: python3(pytest_subprocess)
BuildRequires: python3(pytest_virtualenv)
BuildRequires: python3(pytest_enabler)
BuildRequires: python3(sphinx)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(virtualenv)
BuildRequires: python3(wheel)

# For the tests of the setuptools commands to do binary builds:
BuildPreReq: python3-dev
%endif

# dependencies for build wheel
%if_without bootstrap
BuildRequires: python3(wheel)
BuildRequires: python3(system_seed_wheels)
%endif

Provides: python3-module-distribute = %EVR
Requires: python3-module-pkg_resources = %EVR
# setuptools has commands for doing binary builds; for them to work always:
Requires: python3-dev
# skip requires of self
%filter_from_requires /python3\(\.[[:digit:]]\)\?(pkg_resources\.extern\..*)/d
%filter_from_requires /python3\(\.[[:digit:]]\)\?(setuptools\.extern\..*)/d

# hide bundled packages
%add_findprov_skiplist %python3_sitelibdir/setuptools/_vendor/*

%package -n python3-module-pkg_resources
Summary: Package Discovery and Resource Access for Python3 libraries
Group: Development/Python3
# Not separated yet:
Conflicts: python3-module-%mname < 39.2.0-alt3

# hide bundled packages
%add_findprov_skiplist %python3_sitelibdir/pkg_resources/_vendor/*

%description
Setuptools is a collection of enhancements to the Python3 distutils
that allow you to more easily build and distribute Python3 packages,
especially ones that have dependencies on other packages.

%global pkg_resources_desc The "pkg_resources" module distributed with "setuptools" provides an API\
for Python libraries to access their resource files, and for extensible\
applications and frameworks to automatically discover plugins.  It also\
provides runtime support for using C extensions that are inside zipfile-format\
eggs, support for merging packages that have separately-distributed modules or\
subpackages, and APIs for managing Python's current "working set" of active\
packages.\
\
Any Python code can make use of pkg_resources at runtime (unlike setuptools,\
whose purpose is preparing packages).

%description -n python3-module-pkg_resources
%pkg_resources_desc

This package contains pkg_resources for Python3.

%if_without bootstrap
%package wheel
Summary: %summary
Group: Development/Python3
%py3_requires system_seed_wheels

%description wheel
Provides the seed package for virtualenv(packaged as wheel).
%endif

%prep
%setup
%autopatch -p1

# never unbundle vendored packages
# built wheel being installed into virtualenv will lack of unbundled packages

# Remove bundled exes
rm -f setuptools/*.exe

# do not generate version like release.postdate, we need release one
sed -i '/^tag_build =.*/d;/^tag_date = 1/d' setup.cfg

%build
%global python3_setup_buildrequires %nil
%python3_build_debug

%install
%python3_install

# since we package python modules as arch dependent
%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%if_without bootstrap
%{python3_setup:} bdist_wheel --dist-dir %buildroot%system_wheels_path/
%endif

%check
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
export TOX_TESTENV_PASSENV='PIP_NO_BUILD_ISOLATION'
tox.py3 --sitepackages --console-scripts --no-deps -vvr -s false -- \
    --ignore pavement.py -vra

%files
%doc LICENSE *.rst
%python3_sitelibdir/_distutils_hack/
%python3_sitelibdir/distutils-precedence.pth
%python3_sitelibdir/setuptools

%files -n python3-module-pkg_resources
%doc LICENSE
%python3_sitelibdir/pkg_resources
# People write "setuptools" in *.egg-info/requires.txt (or in setup.py's requires)
# even if they use only the pkg_resources part;
# if setuptools-*.egg-info is not present, pkg_resources.load_entry_point() fails
# (for no real reason). Unfortunately, they have nothing better to write there...
# So we fool this mechanism by putting this file even
# if having incomplete setuptools code.
# Our autoreqs will take over the duty of tracking the real dependencies.
# (In future, we could patch their requires.txt.)
%python3_sitelibdir/setuptools-%version-*.egg-info

%if_without bootstrap
%files wheel
%system_wheels_path/setuptools-%version-*.whl
%endif

%changelog
