%define oname sigtools

%def_without check

Name: python3-module-%oname
Version: 2.0.2
Release: alt3

Summary: Python module to manipulate function signatures

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/sigtools/

Packager: Python Development Team <python@packages.altlinux.org>

# https://github.com/epsy/sigtools.git
# Source-url: https://pypi.io/packages/source/s/%oname/%oname-%version.tar.gz
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%if_with check
BuildRequires: python3-module-unittest2 python3-module-coverage python3-module-mock
%endif

%py3_provides %oname
%py3_requires six funcsigs sphinx

BuildRequires: python3-module-html5lib python3-module-sphinx

%description
Utilities for working with 3.3's inspect.Signature objects.
The sigtools python library provides:

* Decorators to specify keyword-only parameters, annotations and
  positional-only parameters, even on python2: sigtools.modifiers
* Decorators to specify how *args, **kwargs are handled, in a way that
  can be introspected: sigtools.specifiers
* Function combination routines that preserve signatures:
  sigtools.wrappers
* Functions to manipulate signature objects likewise: sigtools.signatures

%prep
%setup

%build
%python3_build

%install
%python3_install
rm -rf %buildroot%python3_sitelibdir/sigtools/tests/

%check
python3 setup.py test

%files
%doc *.rst docs/*.rst*
%python3_sitelibdir/*

%changelog
