%define oname sip

Name: python3-module-sip6
Version: 6.1.1
Release: alt1

Summary: Python3 bindings generator for C/C++ libraries

License: GPLv2, GPLv3 licenses, BSD-like
Group: Development/Python3
URL: http://www.riverbankcomputing.com/software/sip/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-devel
BuildRequires: flex gcc-c++

# generated by 'epm restore --dry-run' from python3-module-sip5-6.1.1/setup.py install_requires
%py3_use packaging
%py3_use toml

#Provides: python3-module-%oname-devel = %version-%release
#Obsoletes: python3-module-%oname-devel < %version-%release

Conflicts: python3-module-sip5
Conflicts: python3-module-sip-devel

%description
SIP is a collection of tools that makes it very easy
to create Python bindings for C and C++ libraries.

SIP comprises a set of build tools and a sip module.
The build tools process a set of specification files
and generates C or C++ code which is then compiled
to create the bindings extension module.
Several extension modules may be installed
in the same Python package.
Extension modules can be built so that they are
independent of the version of Python being used.
In other words a wheel created from them
can be installed with any version of Python starting with v3.5.

The specification files contain a description of the interface
of the C or C++ library, i.e. the classes, methods, functions and variables.
The format of a specification file is almost identical to a C or C++ header file,
so much so that the easiest way of creating a specification file
is to edit a copy of the corresponding header file.

The sip module provides support functions to the automatically generated code.
The sip module is installed as part of the same Python package
as the generated extension modules.
Unlike the extension modules the sip module is specific
to a particular version of Python (e.g. v3.5, v3.6, v3.7, v3.8).

SIP makes it easy to exploit existing C or C++ libraries
in a productive interpretive programming environment.
SIP also makes it easy to take a Python application (maybe a prototype)
and selectively implement parts of the application (maybe for performance reasons) in C or C++.

%package devel
Requires: %name = %EVR
Summary: Development files for SIP 5 (Python 3)
Group: Development/Python3
Requires: python3-devel

%description devel
Development files for SIP 5 (Python 3).


%prep
%setup
# hack to drop .abi3 from binaries (TODO: add support to python3.req/prov)
# see https://www.python.org/dev/peps/pep-3149/
%__subst "s|suffixes = importlib.machinery.EXTENSION_SUFFIXES|suffixes = ['.so']|" sipbuild/buildable.py
%__subst "s|name='sip'|name='sip6'|" setup.py
find -type f | xargs subst "s|sipbuild|sipbuild6|g"
mv -v sipbuild sipbuild6
rm -rfv sip.egg-info/

%build
%python3_build

%install
%python3_install

%files
%doc README NEWS LICENSE*
%_bindir/sip-*
%python3_sitelibdir/sip6-*.egg-info
%python3_sitelibdir/sipbuild6/

%changelog
