%define  modulename sphinxcontrib-programoutput

%def_with check

Name:    python3-module-%modulename
Version: 0.17
Release: alt1

Summary: Sphinx extension for capturing program output

License: BSD-2-Clause
Group:   Development/Python3
URL:     https://github.com/NextThought/sphinxcontrib-programoutput

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro

%if_with check
BuildRequires: python3-module-pytest python3-module-docutils
BuildRequires: python3-module-sphinx strace
%endif

BuildArch: noarch

Source:  %modulename-%version.tar

%description
A Sphinx extension to literally insert the output of arbitrary commands into
documents, helping you to keep your command examples up to date.

%prep
%setup -n %modulename-%version

%build
%python3_build

%install
%python3_install
%python3_prune

# remove .pth file which is useless under python3 and breaks namespace modules
rm %buildroot%python3_sitelibdir/*programoutput*.pth

%check
%__python3 setup.py test

%files
%python3_sitelibdir/sphinxcontrib/programoutput/
%python3_sitelibdir/*.egg-info
%doc *.rst

%changelog
