%define oname tornado

Name: python3-module-%oname
Version: 6.3.2
Release: alt1
Summary: Scalable, non-blocking web server and tools

License: Apache-2.0
Group: Development/Python3
Url: http://www.tornadoweb.org

# https://github.com/tornadoweb/tornado.git
Source: %name-%version.tar
Patch: Do-not-turn-DeprecationWarning-into-Exception.patch

BuildRequires(pre): rpm-build-python3
Requires: ca-certificates python3-module-certifi
%add_python3_req_skip MySQLdb pycurl

%description
Tornado is an open source version of the scalable, non-blocking web
server and tools.

The framework is distinct from most mainstream web server frameworks
(and certainly most Python frameworks) because it is non-blocking and
reasonably fast. Because it is non-blocking and uses epoll, it can
handle thousands of simultaneous standing connections, which means it is
ideal for real-time web services.

%prep
%setup
%patch -p1
# remove shebang from files
sed -i.orig -e '/^#!\//, 1d' *py tornado/*.py tornado/*/*.py

%build
%python3_build

%install
%python3_install
pushd %buildroot%python3_sitelibdir/%oname
rm -rf ca-certificates.crt
ln -sf /usr/share/ca-certificates/ca-bundle.crt ca-certificates.crt

# do not install tests
rm -r %buildroot%python3_sitelibdir/tornado/test

%check
export ASYNC_TEST_TIMEOUT=120
%__python3 -m tornado.test.runtests --verbose

%files
%doc *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info

%changelog
