%define oname tracing

Name: python3-module-%oname
Version: 0.9
Release: alt2

Summary: Python debug logging helper
License: GPLv3+
Group: Development/Python3
Url: http://liw.fi/%oname/
BuildArch: noarch

Source: %name-%version.tar
Source44: import.info

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx


%description
The Python library tracing helps with logging debug messages. It
provides a couple of functions for logging debug messages, and allows
the user to enable or disable logging for particular code modules.

It is sometimes practical to add a lot of debugging log messages to a
program, but having them enabled all the time results in very large
log files. Also, logging that much takes quite a bit of time.

This module provides a way to turn such debugging or tracing messages
on and off, based on the filename they occur in. The logging can that
be left in the code, and only enabled when it is needed.

%package docs
Group: Other
Summary: Documentation for %oname

%description docs
This package contains the documentation for %oname a Python debug
logging helper.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

%build
%python3_build

# Build documentation
make -C doc html

%install
%python3_install

%files
%doc COPYING NEWS README
%python3_sitelibdir_noarch/*

%files docs
%doc doc/_build/html/* example.py


%changelog
