%define _unpackaged_files_terminate_build 1

%define oname traitlets

Name: python3-module-%oname
Version: 5.0.5
Release: alt1
Summary: Traitlets Python config system
License: BSD
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/traitlets

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-macros-sphinx3
BuildRequires: python3-module-decorator python3-module-ipython_genutils-tests python3-module-pytest
BuildRequires: python3-module-sphinx_rtd_theme python3(enum) python3-module-mock
BuildRequires: python3-module-sphinx

%py3_provides %oname
%py3_requires ipython_genutils decorator

%description
A configuration system for Python applications.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
A configuration system for Python applications.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
A configuration system for Python applications.

This package contains pickles for %oname.

%prep
%setup

%prepare_sphinx3 docs
ln -s ../objects.inv docs/source/

%build
%python3_build

%install
%python3_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html
cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/

%check
rm -fR build
py.test3 -vv

%files
%doc examples docs/build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests

%files pickles
%python3_sitelibdir/*/pickle

%changelog
