%define _unpackaged_files_terminate_build 1

%define oname waitress
%def_with check

Name: python3-module-%oname
Version: 2.1.2
Release: alt1

Summary: Waitress WSGI server
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/waitress/
Vcs: https://github.com/Pylons/waitress

BuildArch: noarch

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
%endif

Conflicts: python-module-%oname

%description
Waitress is meant to be a production-quality pure-Python WSGI server with
very acceptable performance. It has no dependencies except ones which live
in the Python standard library. It runs on CPython on Unix and Windows under
Python 2.6+ and Python 3.2. It is also known to run on PyPy 1.6.0 on UNIX.
It supports HTTP/1.0 and HTTP/1.1.

For more information, see the "docs" directory of the Waitress package or
visit https://docs.pylonsproject.org/projects/waitress/en/latest/

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc README.rst CHANGES.txt COPYRIGHT.txt LICENSE.txt
%_bindir/waitress-serve
%python3_sitelibdir/waitress/
%python3_sitelibdir/waitress-%version.dist-info

%changelog
