%define _unpackaged_files_terminate_build 1

%define oname zconfig

Name: python3-module-%oname
Version: 3.2.0
Release: alt3

Summary: Python configuration module from Zope
License: ZPL
Group: Development/Python3
Url: http://pypi.python.org/pypi/ZConfig/

BuildArch: noarch

# https://github.com/zopefoundation/ZConfig.git
Source: %name-%version.tar
# https://github.com/zopefoundation/ZConfig/issues/34
Patch1: %oname-%version-upstream-schema2html.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-manuel
BuildRequires: python3-module-manuel-tests
BuildRequires: python3-module-docutils

Conflicts: python-module-%oname < 3.2.0-alt2


%description
ZConfig is a configuration library intended for general use. It supports a
hierarchical schema-driven configuration model that allows a schema to specify
data conversion routines written in Python. ZConfig\'s model is very different
from the model supported by the ConfigParser module found in Python\'s standard
library, and is more suitable to configuration-intensive applications.

ZConfig schema are written in an XML-based language and are able to \"import\"
schema components provided by Python packages. Since components are able to
bind to conversion functions provided by Python code in the package (or
elsewhere), configuration objects can be arbitrarily complex, with values that
have been verified against arbitrary constraints. This makes it easy for
applications to separate configuration support from configuration loading even
with configuration data being defined and consumed by a wide range of separate
packages.

Authors:
--------
Zope Corporation < zodb-devAATTzope.org>

%package tests
Summary: Tests for ZConfig
Group: Development/Python3
Requires: %name = %version-%release
%py3_requires zope.testrunner

%description tests
ZConfig is a configuration library intended for general use. It supports a
hierarchical schema-driven configuration model that allows a schema to specify
data conversion routines written in Python. ZConfig\'s model is very different
from the model supported by the ConfigParser module found in Python\'s standard
library, and is more suitable to configuration-intensive applications.

This package contains tests for ZConfig.

%prep
%setup
%patch1 -p1

sed -i 's|cgi|html|' ZConfig/schema2html.py

%build
%python3_build

%install
%python3_install

%check
%__python3 setup.py test

%files
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/*/tests

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/*/tests


%changelog
