%define oname zmq

%def_without bootstrap

Name: python3-module-%oname
Version: 22.1.0
Release: alt1
Summary: Software library for fast, message-based applications

Group: Development/Python3
License: LGPLv3+ and BSD-3-Clause
Url: http://www.zeromq.org/bindings:python
# http://github.com/zeromq/pyzmq.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libzeromq-devel
BuildRequires: python3-module-Cython
%if_without bootstrap
BuildPreReq: python3-module-numpy
%endif

%description
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialized messaging middle-ware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging
patterns, message filtering (subscriptions), seamless access to
multiple transport protocols and more.

This package contains the python bindings.

%package tests
Summary: Software library for fast, message-based applications
Group: Development/Python3
License: LGPLv3+

%description tests
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialized messaging middle-ware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging
patterns, message filtering (subscriptions), seamless access to
multiple transport protocols and more.

This package contains the testsuite for the python bindings.

%package devel
Summary: Software library for fast, message-based applications
Group: Development/Python3
Requires: %name = %version-%release

%description devel
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialized messaging middle-ware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging
patterns, message filtering (subscriptions), seamless access to
multiple transport protocols and more.

This package contains the headers for the python bindings.

%prep
%setup
cp setup.cfg.template setup.cfg
subst "s|/usr/local/lib|%_libdir|" setup.cfg
subst "s|/usr/local/include|%_includedir|" setup.cfg

%build
%add_optflags -fno-strict-aliasing
%python3_build

%install
%python3_install

#check
#rm %oname/__*
#PYTHONPATH=%buildroot%python3_sitelibdir python3 setup.py test
#rm -rf %python3_sitelibdir/%oname/backend/cffi/__*
#rm -rf %buildroot%python3_sitelibdir/%oname/backend/cffi/__*

%files
%doc README.md COPYING.LESSER COPYING.BSD CONTRIBUTING.md AUTHORS.md examples/
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%oname
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/*/*.h

%files devel
%python3_sitelibdir/%oname/*/*.h

%files tests
%python3_sitelibdir/%oname/tests

%changelog
