%define _unpackaged_files_terminate_build 1
%define oname zope.i18n

%def_with check

Name: python3-module-%oname
Version: 4.7.0
Release: alt1

Summary: Zope Internationalization Support
License: ZPLv2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.i18n
#Git: https://github.com/zopefoundation/zope.i18n.git

Source: %name-%version.tar
Patch0: %oname-fix-tests.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python3-module-gettext
BuildRequires: python3-module-pytz
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.i18nmessageid
BuildRequires: python3-module-zope.schema
BuildRequires: python3-module-zope.deprecation
BuildRequires: python3-module-zope.publisher
%endif

%py3_requires zope.deprecation
%py3_requires zope.schema
%py3_requires zope.i18nmessageid
%py3_requires zope.component
%py3_requires zope.deferredimport
%py3_requires zope.hookable

%description
This package implements several APIs related to internationalization and
localization.

* Locale objects for all locales maintained by the ICU project.
* Gettext-based message catalogs for message strings.
* Locale discovery for Web-based requests.

%package tests
Summary: Tests for zope.i18n (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-module-zope.component-tests
%py3_requires zope.publisher
%py3_requires zope.testrunner

%description tests
This package contains tests for %oname.

%prep
%setup
%patch0 -p2

%build
%python3_build

%install
%python3_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
export PYTHONPATH=src
zope-testrunner3 --test-path=src -vv

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/zope/i18n/testing.*
%exclude %python3_sitelibdir/zope/i18n/*/testing.*
%exclude %python3_sitelibdir/zope/i18n/tests
%exclude %python3_sitelibdir/zope/i18n/locales/tests

%files tests
%python3_sitelibdir/zope/i18n/testing.*
%python3_sitelibdir/zope/i18n/*/testing.*
%python3_sitelibdir/zope/i18n/tests
%python3_sitelibdir/zope/i18n/locales/tests

%changelog
