%define _unpackaged_files_terminate_build 1
%define oname zope.password

%def_with check

Name: python3-module-%oname
Version: 4.3.1
Release: alt2
Summary: Password encoding and checking utilities
License: ZPL
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.password/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-virtualenv
BuildRequires: python3-module-coverage
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-bcrypt
BuildRequires: python3-module-repoze.sphinx.autointerface
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.browser
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.security
%endif

%py3_requires zope zope.component zope.configuration zope.interface

%description
This package provides a password manager mechanism. Password manager is
an utility object that can encode and check encoded passwords.

%package tests
Summary: Tests for zope.password
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.schema

%description tests
This package provides a password manager mechanism. Password manager is
an utility object that can encode and check encoded passwords.

This package contains tests for zope.password.

%prep
%setup

%build
%python3_build

%install
%python3_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done

%check
# FIXME: this is a hack to invoke /usr/bin/coverage3 from python3-module-coverage
# while tox.ini tries to invoke /usr/bin/coverage
# Is coverage{3} needed during package buildtime unittesting at all?
sed -i 's|coverage r|coverage3 r|g' tox.ini
sed -i 's|zope-testrunner|zope-testrunner3|g' tox.ini
sed -i 's|sphinx-build|py3_sphinx-build|g' tox.ini

export PYTHONPATH=%python3_sitelibdir_noarch:%python3_sitelibdir:src
TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 --sitepackages -e py%{python_version_nodots python3} -v

%files
%doc *.txt *.rst
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*

%changelog
