%define _unpackaged_files_terminate_build 1
%define oname zope.publisher

%def_with check

Name: python3-module-%oname
Epoch: 1
Version: 6.0.1
Release: alt1

Summary: The Zope publisher publishes Python objects on the web (Python3)
License: ZPLv2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.publisher
#Git: https://github.com/zopefoundation/zope.publisher.git

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-zope.browser
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.contenttype
BuildRequires: python3-module-zope.i18n
BuildRequires: python3-module-zope.interface-tests
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.security
BuildRequires: python3-module-zope.security-tests
BuildRequires: python3-module-zope.deferredimport
BuildRequires: python3-module-zope.hookable
BuildRequires: python3-module-zope.deprecation
BuildRequires: python3-module-zope.event
BuildRequires: python3-module-multipart
%endif

%py3_requires zope.browser
%py3_requires zope.component
%py3_requires zope.configuration
%py3_requires zope.contenttype
%py3_requires zope.event
%py3_requires zope.exceptions
%py3_requires zope.i18n
%py3_requires zope.interface
%py3_requires zope.location
%py3_requires zope.proxy
%py3_requires zope.security
%py3_requires zope.deferredimport
%py3_requires zope.hookable
%py3_requires zope.deprecation

%description
zope.publisher allows you to publish Python objects on the web. It has
support for plain HTTP/WebDAV clients, web browsers as well as XML-RPC
and FTP clients. Input and output streams are represented by request and
response objects which allow for easy client interaction from Python.
The behaviour of the publisher is geared towards WSGI compatibility.

%package tests
Summary: Tests for zope.publisher
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testrunner
%py3_requires zope.testing
Requires: python3-module-zope.security-tests
Requires: python3-module-zope.component-tests
Requires: python3-module-zope.interface-tests

%description tests
This package contains tests for %oname.

%prep
%setup
%patch0 -p1

%build
%python3_build

%install
%python3_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
export PYTHONPATH=src
zope-testrunner3 --test-path=src -vv

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*

%changelog
