%define oname zope.tal

Name: python3-module-%oname
Version: 4.2.0
Release: alt3

Summary: Zope 3 Template Application Languate (TAL)
License: ZPL
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.tal/

# https://github.com/zopefoundation/zope.tal.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-fix-test-for-unicode-for-python3.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.i18nmessageid
BuildRequires: python-tools-2to3

%py3_requires zope zope.i18nmessageid zope.interface


%description
The Zope3 Template Attribute Languate (TAL) specifies the custom
namespace and attributes which are used by the Zope Page Templates
renderer to inject dynamic markup into a page. It also includes the
Macro Expansion for TAL (METAL) macro language used in page assembly.

The dynamic values themselves are specified using a companion language,
TALES (see the 'zope.tales' package for more).

%package tests
Summary: Tests for Zope 3 Template Application Languate (TAL)
Group: Development/Python3
Requires: %name = %version-%release
%py3_requires zope.testing

%description tests
The Zope3 Template Attribute Languate (TAL) specifies the custom
namespace and attributes which are used by the Zope Page Templates
renderer to inject dynamic markup into a page. It also includes the
Macro Expansion for TAL (METAL) macro language used in page assembly.

The dynamic values themselves are specified using a companion language,
TALES (see the 'zope.tales' package for more).

This package contains tests for Zope 3 Template Application Languate.

%prep
%setup
%patch1 -p1

find -type f -name '*.py' -exec 2to3 -w '{}' +

sed -i 's|#!.*/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

sed -i 's|.*def setSourceFile\(.*\)|    def setSourceFile\1|' \
    src/zope/tal/interfaces.py
sed -i 's|.*def setGlobal\(.*\)|    def setGlobal\1|' \
    src/zope/tal/interfaces.py

%build
%python3_build

%install
%python3_install

%if "%_lib" == "lib64"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%__python3 setup.py test

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/runtest.*
%exclude %python3_sitelibdir/*/*/*/runtest.*

%files tests
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/runtest.*
%python3_sitelibdir/*/*/*/runtest.*


%changelog
