%define _unpackaged_files_terminate_build 1
%define oname zope.testrunner

%def_with check

Name: python3-module-%oname
Version: 5.3.0
Release: alt2

Summary: Zope testrunner script

License: ZPL-2.1
Group: Development/Python3
# Source-git: https://github.com/zopefoundation/zope.testrunner.git
Url: http://pypi.python.org/pypi/zope.testrunner

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-six
%endif

Conflicts: python-module-%oname

%py3_requires zope

%description
This package provides a flexible test runner with layer support.

%prep
%setup
# ALT zope subpackages have to be packaged without pth files
# due to import errors caused by a namespace specifics.
# Likewise this file should be removed before tests run.
sed -i '/commands[[:space:]]*=/a \    bash -c "rm -f {envsitepackagesdir}/*-nspkg.pth"' \
       tox.ini

%build
%python3_build

%install
%python3_install
%python3_prune

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot{%python3_sitelibdir_noarch/*,%python3_sitelibdir}
%endif

cp -al %buildroot%_bindir/zope-testrunner{,3}

%check
export PIP_INDEX_URL=http://host.invalid./
export PYTHONPATH=build/lib
tox.py3 --sitepackages -e py%{python_version_nodots python3} -v -- -v

%files
%doc *.rst
%_bindir/zope-testrunner
%_bindir/zope-testrunner3
%python3_sitelibdir/*

%changelog
