# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name:    qps
Version: 2.8.0
Release: alt1
Summary: Visual process status monitor
License: GPL-2.0-or-later
Group:   Monitoring
URL:     https://github.com/lxqt/qps
Source0: %name-%version.tar
Source1: %name.desktop

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: qt5-tools-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: lxqt-build-tools >= 0.6.0
BuildRequires: liblxqt-devel >= 0.15.0
BuildRequires: kf5-kwindowsystem-devel
BuildRequires: /usr/bin/convert

%description
Qps is a perfect visual process manager, an X11 version of "top" or "ps" that displays processes in a window and lets you sort and manipulate them easily
Qps can
    * change nice value of a process
    * alter the scheduling policy and soft realtime priority of a process
    * display the TCP/UDP sockets used by a process, and names of the connected hosts (Linux only)
    * display the memory mappings of the process (which files and shared libraries are loaded where)
    * display the open files of a process, and the state of unix domain sockets
    * kill or send any other signal to selected processes
    * display the load average as a graph, and use this as its icon when iconified
    * show (as graph or numbers) current CPU, memory and swap usage
    * sort the process table on any attribute (size, cpu usage, owner etc)
    * on SMP systems running Linux 2.1 or later (or Solaris), display cpu usage for each processor, and which CPU a process is running on
    * display the environment variables of any process
    * show the process table in tree form, showing the parent-child relationship
    * execute user-defined commands on selected processes
    * display MOSIX-specific fields and migrate processes to other nodes in a cluster
%prep
%setup

%build
%cmake
%cmake_build

%install
%cmakeinstall_std
install -pD -m 644 %SOURCE1 %buildroot%_desktopdir/%name.desktop

# Icons
mkdir -p %buildroot/{%_miconsdir,%_niconsdir,%_liconsdir}
convert -resize 32x32 icon/%name.png %buildroot%_niconsdir/%name.png
convert -resize 16x16 icon/%name.png %buildroot%_miconsdir/%name.png

%files
%dir %_datadir/%name
%doc CHANGELOG COPYING README.md
%_man1dir/*
%_bindir/*
%_datadir/%name
%_datadir/metainfo/org.lxqt.Qps.appdata.xml
%_desktopdir/%name.desktop
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png

%changelog
