%define _unpackaged_files_terminate_build 1

%define oname qscintilla2

Name: qscintilla2
Version: 2.11.5
Release: alt4

Summary: QScintilla is a port to Qt of Neil Hodgson's Scintilla C++ editor class

License: GPLv3
Group: Development/KDE and QT
Url: https://riverbankcomputing.com/software/qscintilla

# Source-url: https://www.riverbankcomputing.com/static/Downloads/QScintilla/%version/QScintilla-%version.zip
Source: QScintilla-%version.tar
Patch1: %name-%version-alt-build.patch

%define libname lib%{oname}

BuildRequires: gcc-c++
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-devel
BuildRequires(pre): rpm-macros-qt5
BuildRequires: qt5-base-devel qt5-tools-devel
BuildRequires: python3-module-PyQt5-devel python3-module-sip5

%description
Qscintilla is a free source code editing component. It comes with complete
source code and a license that permits use in any free project or commercial
product. As well as features found in standard text editing components,
Scintilla includes features especially useful when editing and debugging
source code. These include support for syntax styling, error indicators, code
completion and call tips. The selection margin can contain markers like those
used in debuggers to indicate breakpoints and the current line. Styling
choices are more open than with many editors, allowing the use of proportional
fonts, bold and italics, multiple foreground and background colours and
multiple fonts.

%package -n %libname-qt5
Summary: QScintilla is a port to Qt5 of Neil Hodgson's Scintilla C++ editor class.
Group: Development/KDE and QT
Conflicts: lib%oname-11-qt5
Obsoletes: lib%oname-11-qt5
Conflicts: lib%oname-12-qt5
Obsoletes: lib%oname-12-qt5
Conflicts: lib%oname-13-qt5
Obsoletes: lib%oname-13-qt5
Conflicts: lib%oname-15-qt5
Obsoletes: lib%oname-15-qt5

%description -n %libname-qt5
Qscintilla is a free source code editing component. It comes with complete
source code and a license that permits use in any free project or commercial
product. As well as features found in standard text editing components,
Scintilla includes features especially useful when editing and debugging
source code. These include support for syntax styling, error indicators, code
completion and call tips. The selection margin can contain markers like those
used in debuggers to indicate breakpoints and the current line. Styling
choices are more open than with many editors, allowing the use of proportional
fonts, bold and italics, multiple foreground and background colours and
multiple fonts.

%package -n lib%oname-qt5-devel
Requires: %libname-qt5 = %EVR
Requires: qt5-base-devel
Summary: Header files for %oname-qt5
Group: Development/KDE and QT

%description -n lib%oname-qt5-devel
Header files for %oname-qt5

%package -n lib%oname-qt5-designer
Requires: %libname-qt5 = %EVR
Summary: QScintilla designer plugin
Group: Development/KDE and QT

%description -n lib%oname-qt5-designer
QScintillla designer plugin.


%package -n python3-module-%oname-qt5
Requires: %libname-qt5 = %EVR
Summary: Python 3 bindings for %oname (Qt5)
Group: Development/KDE and QT
%py3_provides PyQt5.Qsci

%description -n python3-module-%oname-qt5
Python bindings for %oname

%package -n python3-module-%oname-qt5-devel
Requires: python3-module-%oname-qt5 = %EVR
Summary: Python 3 bindings for %oname (Qt5)
Group: Development/KDE and QT

%description -n python3-module-%oname-qt5-devel
Devel files for Python bindings for %oname


%package -n %libname-doc
Summary: Documentation for %oname
Group: Development/KDE and QT
BuildArch: noarch

%description -n %libname-doc
Documentation for %oname


%prep
%setup -n QScintilla-%version
%patch1 -p2
Q5CFLAGS="$(pkg-config --cflags Qt5Widgets)"
Q5CFLAGS="$Q5CFLAGS $(pkg-config --cflags Qt5PrintSupport)"
sed -i \
	-e "s|@Q5CFLAGS@|$Q5CFLAGS|g" \
	-e "s|@QSCINTILLALIB@|qscintilla2_qt5|g" \
	Python/configure.py

%build

forDebug() {
	# around of bug in /usr/lib/rpm/debugedit
	sed -i 's|\(QTDIR)\)/|\1|g' Makefile
}

%ifarch %e2k
# bits/c++0x_warning.h
%add_optflags -std=gnu++11
%endif

# Qt5
pushd Qt4Qt5
qmake-qt5 QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" qscintilla.pro
forDebug
%make_build
popd

# Designer for Qt5
pushd designer-Qt4Qt5
qmake-qt5 QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" designer.pro
forDebug
%make_build
popd

pushd Python
python3 configure.py --debug -n ../Qt4Qt5 -o ../Qt4Qt5 \
	--apidir=%_datadir/qt5/qsci3 \
	--qmake=%_qt5_bindir/qmake \
	--pyqt=PyQt5
sed -i \
	's|-lpython%_python3_version|-lpython%{_python3_version}m|g' \
	Makefile
%make_build
popd

%install

# Python bindings for PyQt5
pushd Python
mkdir -p %buildroot%python3_sitelibdir/PyQt5
%makeinstall_std INSTALL_ROOT=%buildroot
popd

mkdir -p %buildroot%python3_sitelibdir/PyQt5
mkdir -p %buildroot%_includedir/qt5/Qsci
mkdir -p %buildroot%_qt5_libdatadir
mkdir -p %buildroot%_qt5_translationdir
mkdir -p %buildroot%_qt5_plugindir/designer
mkdir -p %buildroot%_datadir/sip/qsci
mkdir -p %buildroot%_datadir/qt5/qsci/api/python

# Qt5 library
install Qt4Qt5/lib%{oname}_qt5.so.*.*.* %buildroot%_libdir
install Qt4Qt5/*.qm %buildroot%_qt5_translationdir
pushd %buildroot%_libdir
ln -s lib%{oname}_qt5.so.*.*.* `ls lib%{oname}_qt5.so.*.*.* | sed s/\.[0-9]*$//`
ln -s lib%{oname}_qt5.so.*.*.* `ls lib%{oname}_qt5.so.*.*.* | sed s/\.[0-9]*\.[0-9]*$//`
ln -s lib%{oname}_qt5.so.*.*.* `ls lib%{oname}_qt5.so.*.*.* | sed s/\.[0-9]*\.[0-9]*\.[0-9]*$//`
popd

pushd %buildroot%_qt5_libdatadir
for libname in ../../../%_lib/lib%{oname}_qt5.*; do
ln -s $libname ./
done
popd

# Qt5 designer
install -D designer-Qt4Qt5/libqscintillaplugin.so %buildroot%_qt5_plugindir/designer

# Qt5 headers
install -m644 Qt4Qt5/*.h %buildroot%_qt5_headerdir/
install -m644 Qt4Qt5/Qsci/*.h %buildroot%_qt5_headerdir/Qsci/

# docs
mkdir -p %buildroot%_docdir/%libname-%version
cp -a doc/Scintilla %buildroot%_docdir/%libname-%version
cp -a doc/html-Qt4Qt5 %buildroot%_docdir/%libname-%version
cp ChangeLog NEWS LICENSE %buildroot%_docdir/%libname-%version

rm -rf %buildroot/%python3_sitelibdir/QScintilla-%version.dist-info

%files -n %libname-qt5
%_qt5_libdatadir/*.so.*
%_libdir/*_qt5.so.*
%_qt5_translationdir/*

%files -n lib%oname-qt5-devel
%_includedir/qt5/*.h
%_includedir/qt5/Qsci
%_qt5_libdatadir/*.so
%_libdir/*_qt5.so

%files -n lib%oname-qt5-designer
%_qt5_plugindir/designer/*.so

%files -n python3-module-%oname-qt5
%python3_sitelibdir/PyQt5/Qsci.so
%python3_sitelibdir/PyQt5/Qsci.pyi
%_datadir/qt5/qsci3/api/python/*.api

%files -n python3-module-%oname-qt5-devel
%dir %python3_sitelibdir/PyQt5/bindings/
%dir %python3_sitelibdir/PyQt5/bindings/Qsci/
%python3_sitelibdir/PyQt5/bindings/Qsci/*


%files -n %libname-doc
%_docdir/%libname-%version

%changelog
