# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: qterminal
Version: 1.4.0
Release: alt1

Summary: Qt-based multitab terminal emulator
License: GPL-2.0-only
Group: Terminals

Url: http://github.com/qterminal/qterminal
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake lxqt-build-tools
BuildRequires: qt5-base-devel qt5-tools-devel qt5-x11extras-devel
BuildRequires: libqtermwidget-devel >= %version

%description
Qt-based multitab terminal emulator based on QTermWidget.

Initially this project was started as an attempt to create relatively
light and stable terminal emulator application like Konsole or
gnome-terminal but without any dependency from such monsters as KDE or
Gnome. I was looking for such kind of application for a long time but
haven't found anything worth while. That's why when I met QTermWidget
and tried it I was really happy! :) That was exactly what I need.
Actually I didn't pay much effort for its improvement, I've just put it
into tab widget, add basic config and some useful actions. Seems that's
pretty much enough for now.

0.4.0+ is a friendly fork, the original project is still available
at http://qterminal.sourceforge.net/

%prep
%setup

%build
%ifarch %e2k
%add_optflags -std=c++11
%endif
%cmake \
    -DUSE_QT5=true \
    -DQTERMWIDGET_PATH_SHARE=%_datadir/qtermwidget5
%cmake_build

%install
%cmake_install

%files
%doc AUTHORS LICENSE CHANGELOG README*
%_bindir/%name
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*
%_datadir/metainfo/%name.metainfo.xml
%_datadir/%name

%changelog
