%define _unpackaged_files_terminate_build 1

%global sover 4

Name: rabbitmq-c
Version: 0.13.0
Release: alt2

Summary: RabbitMQ C client
Group: System/Libraries
License: MIT
URL: https://github.com/alanxz/rabbitmq-c

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

Obsoletes: librabbitmq-c < %EVR

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ctest xmlto
BuildRequires: doxygen
BuildRequires: graphviz
BuildRequires: libssl-devel
BuildRequires: libpopt-devel

%description
This is a C-language AMQP client library for use with v2.0+ of the
RabbitMQ broker.

%package -n librabbitmq-c%sover
Summary: Libraries for %name
Group: System/Libraries
Provides: librabbitmq-c = %EVR
Conflicts: librabbitmq-c

%description -n librabbitmq-c%sover
%summary

%package -n librabbitmq-c-devel
Summary: Development files for %name
Group: System/Libraries
Requires: pkgconfig

%description -n librabbitmq-c-devel
%summary

%prep
%setup
%patch0 -p1

%build
%cmake \
	-DCMAKE_SKIP_RPATH:BOOL=NO \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=YES \
	-DBUILD_API_DOCS=ON \
	-DBUILD_TOOLS:BOOL=ON \
	-DBUILD_TOOLS_DOCS:BOOL=ON

%cmake_build

%install
%cmake_install
rm -f %buildroot%_libdir/*.a

%check
pushd %_cmake__builddir
	ctest -VV
popd

%files
%doc AUTHORS CONTRIBUTING.md ChangeLog.md LICENSE README.md THANKS
%_bindir/*
%_man1dir/*
%_man7dir/*

%files -n librabbitmq-c%sover
%_libdir/librabbitmq.so.*

%files -n librabbitmq-c-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_libdir/cmake

%changelog
