%define _unpackaged_files_terminate_build 1
%def_with check

Name: rng-tools
Version: 6.14
Release: alt1.git82f665c4

Summary: Random number generator related utilities
License: GPLv2+
Group: System/Kernel and hardware

URL: https://github.com/nhorman/rng-tools
#Git: https://github.com/nhorman/rng-tools.git
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.default
Source3: %name.service

Patch0: %name-%version.patch

# Automatically added by buildreq on Wed Apr 03 2019
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config
# libsasl2-3 libssl-devel perl pkg-config python-base sh4
BuildRequires: libcurl-devel
BuildRequires: libxml2-devel
BuildRequires: libp11-devel
BuildRequires: jitterentropy-devel
BuildRequires: libjansson-devel
BuildRequires: rtl-sdr-devel
%if_with check
BuildRequires: /proc
%endif

Obsoletes: kernel-utils

%description
Hardware random number generation tool.
It monitors a set of entropy sources, and supplies entropy from them
to the system kernel's /dev/random machinery.

%prep
%setup
%patch0 -p1

%build
./autogen.sh
%configure
%make_build

%install
%makeinstall_std
mkdir -p %buildroot{%_initdir,%_sysconfdir/sysconfig,%_unitdir}
install -m755 %SOURCE1 %buildroot%_initdir/rngd
install -m644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/rngd
install -m644 %SOURCE3 %buildroot%_unitdir/rngd.service

%check
make check

%post
%post_service rngd

%preun
%preun_service rngd

%files
%config(noreplace) %_sysconfdir/sysconfig/rngd
%_initdir/rngd
%_unitdir/rngd.service
%_bindir/rngtest
%_bindir/randstat
%_sbindir/rngd
%_man1dir/rngtest.1*
%_man8dir/rngd.8*

%changelog
