%define oldname rngom
Epoch: 0
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: rngom201103
Version: 201103
Release: alt4_0.18.20120119svnjpp8
Summary: Java library for parsing RELAX NG grammars
License: MIT
URL: https://java.net/projects/rngom

# svn export -r 70 https://svn.java.net/svn/rngom~svn/trunk/rngom rngom-201103
# find rngom-201103/ -name '*.class' -delete
# find rngom-201103/ -name '*.jar' -delete
# tar czf rngom-201103.tar.gz rngom-201103
Source0: %{oldname}-%{version}.tar.gz
Patch0: %{oldname}-%{version}-pom.patch

BuildRequires:  maven-local
BuildRequires:  mvn(com.sun.msv.datatype.xsd:xsdlib)
BuildRequires:  mvn(javax.xml.stream:stax-api)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.maven.plugins:maven-clean-plugin)
BuildRequires:  mvn(org.codehaus.mojo:javacc-maven-plugin)
BuildRequires:  mvn(org.sonatype.oss:oss-parent:pom:)
BuildRequires:  mvn(relaxngDatatype:relaxngDatatype:20020414)
BuildRequires:  mvn(xmlunit:xmlunit)

BuildArch: noarch
Source44: import.info

%description
RNGOM is an open-source Java library for parsing RELAX NG grammars.

In particular, RNGOM can:
* parse the XML syntax
* parse the compact syntax
* check all the semantic restrictions as specified in the specification
* parse RELAX NG into application-defined data structures
* build a default data structure based around the binarized simple syntax or
  another data structure that preserves more of the parsed information
* parse foreign elements/attributes in a schema
* parse comments in a schema

%package javadoc
Group: Development/Java
Summary: Javadoc for %{oldname}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{oldname}.

%prep
%setup -n %{oldname}-%{version} -q
%patch0 -p1

%mvn_compat_version : 20100718 %{version}

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference licenceheader.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference licenceheader.txt

%changelog
