%define clang_version 12

%define git_ver 12699
%define git_commit 9c0c8f2bc7a09aa09825992964e8a916b25d888b

%define glslang_version 11.5.0
%define asmjit_commit 723f58581afc0f4cb16ba13396ff77e425896847
%define hidapi_commit 01f601a1509bf9c67819fbf521df39644bab52d5
%define yaml_cpp_commit 6a211f0bc71920beef749e6c35d7d1bcc2447715
%define llvm_commit 5836324d6443a62ed09b84c125029e98324978c3
%define spirv_headers_version 1.5.3.reservations1
%define spirv_tools_version 2020.4

Name: rpcs3
Version: 0.0.18
Release: alt1.p10.2

Summary: PS3 emulator/debugger
License: GPLv2
Group: Emulators

Url: https://%name.net/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64

# https://github.com/RPCS3/%name/archive/v%version/%name-%version.tar.gz
Source0: %name-%version.tar
# https://github.com/KhronosGroup/glslang/archive/%glslang_version/glslang-%glslang_version.tar.gz
Source1: glslang-%glslang_version.tar
# https://github.com/asmjit/asmjit/archive/%asmjit_commit/asmjit-%asmjit_commit.tar.gz
Source2: asmjit-%asmjit_commit.tar
# https://github.com/RPCS3/hidapi/archive/%hidapi_commit/hidapi-%hidapi_commit.tar.gz
Source3: hidapi-%hidapi_commit.tar
# https://github.com/RPCS3/yaml-cpp/archive/%yaml_cpp_commit/yaml-cpp-%yaml_cpp_commit.tar.gz
Source4: yaml-cpp-%yaml_cpp_commit.tar
# https://github.com/RPCS3/llvm-mirror/archive/%llvm_commit/llvm-mirror-%llvm_commit.tar.gz
Source5: llvm-mirror-%llvm_commit.tar
# https://github.com/KhronosGroup/SPIRV-Headers/archive/%spirv_headers_version/SPIRV-Headers-%spirv_headers_version.tar.gz
Source6: SPIRV-Headers-%spirv_headers_version.tar
# https://github.com/KhronosGroup/SPIRV-Tools/archive/v%spirv_tools_version/SPIRV-Tools-%spirv_tools_version.tar.gz
Source7: SPIRV-Tools-%spirv_tools_version.tar

Patch0: %name-alt-git.patch
Patch1: %name-new-flatbuffers.patch
Patch2: %name-new-vulkan.patch

BuildRequires: /proc
BuildRequires: clang%clang_version.0
BuildRequires: cmake >= 3.16.9
BuildRequires: git-core
BuildRequires: libflatbuffers-devel
BuildRequires: libpugixml-devel
BuildRequires: pkgconfig(FAudio)
BuildRequires: pkgconfig(Qt5) >= 5.15.2
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(glew)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libevdev)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(libxxhash)
BuildRequires: pkgconfig(openal)
BuildRequires: pkgconfig(python3)
BuildRequires: pkgconfig(sdl2)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(wayland-server)
BuildRequires: pkgconfig(wolfssl)
BuildRequires: llvm%clang_version.0
BuildRequires: ocaml-ctypes
BuildRequires: ocaml-findlib
BuildRequires: python3-module-yaml

BuildPreReq: pkgconfig(libswresample)
BuildPreReq: python3-module-Pygments

%description
The world's first free and open-source PlayStation 3 emulator/debugger, written in C++ for Windows and Linux.

%prep
%setup -b 1 -b 2 -b 3 -b 4 -b 5 -b 6 -b 7

%patch0 -p1
%patch1 -p1
%patch2 -p1

%__mv -Tf ../glslang-%glslang_version 3rdparty/glslang/glslang
%__mv -Tf ../asmjit-%asmjit_commit 3rdparty/asmjit/asmjit
%__mv -Tf ../hidapi-%hidapi_commit 3rdparty/hidapi/hidapi
%__mv -Tf ../yaml-cpp-%yaml_cpp_commit 3rdparty/yaml-cpp/yaml-cpp
%__mv -Tf ../llvm-mirror-%llvm_commit llvm
%__mv -Tf ../SPIRV-Headers-%spirv_headers_version 3rdparty/SPIRV/SPIRV-Headers
%__mv -Tf ../SPIRV-Tools-%spirv_tools_version 3rdparty/SPIRV/SPIRV-Tools

#Generate Version Strings
GIT_VERSION=$(echo %git_ver)
GIT_COMMIT=$(echo %git_commit)

echo "// This is a generated file.

#define RPCS3_GIT_VERSION \"$GIT_VERSION-${GIT_COMMIT:0:8}\"
#define RPCS3_GIT_BRANCH \"master\"
#define RPCS3_GIT_FULL_BRANCH \"RPCS3/rpcs3/master\"

// If you don't want this file to update/recompile, change to 1.
#define RPCS3_GIT_VERSION_NO_UPDATE 1
" > %name/git-version.h

%build
%remove_optflags %optflags_lto

export CC="clang-%clang_version"
export CXX="clang++-%clang_version"
export LINKER="lld-%clang_version"
export AR="llvm-ar-%clang_version"
export RANLIB="llvm-ranlib-%clang_version"

%cmake \
	-DCMAKE_LINKER:STRING="$LINKER" \
	-DCMAKE_AR:STRING="$AR" \
	-DCMAKE_RANLIB:STRING="$RANLIB" \
	-DUSE_NATIVE_INSTRUCTIONS:BOOL=FALSE \
	-DUSE_SYSTEM_FFMPEG:BOOL=TRUE \
	-DUSE_SYSTEM_LIBPNG:BOOL=TRUE \
	-DUSE_SYSTEM_CURL:BOOL=TRUE \
	-DUSE_SYSTEM_LIBUSB:BOOL=TRUE \
	-DUSE_SYSTEM_FLATBUFFERS:BOOL=TRUE \
	-DUSE_SYSTEM_PUGIXML:BOOL=TRUE \
	-DUSE_SYSTEM_XXHASH:BOOL=TRUE \
	-DUSE_SYSTEM_WOLFSSL:BOOL=TRUE \
	-DUSE_SYSTEM_FAUDIO:BOOL=TRUE \
	-DLLVM_USE_LINKER:STRING="$LINKER" \
	-DPython3_EXECUTABLE="%__python3" \
	-Wno-dev

%cmake_build

%install
%cmakeinstall_std

%files
%doc LICENSE README.md
%_bindir/%name
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/%name
%_datadir/metainfo/%name.metainfo.xml

%changelog
