# vim: set ft=spec: -*- spec -*-
%def_with kde
%def_disable sound
%define program_prefix rss-

Name: rss_glx
Version: 0.9.1
Release: alt8

Summary: Really Slick Screensavers
License: GNU GPL
Group: Graphical desktop/Other

Url: http://rss-glx.sourceforge.net
Source: %name-%version-%release.tar
Patch0: rss-glx-0.9.1-debian-configure.patch
Patch1: rss-glx-0.9.1-debian-pixelcity-cpp.patch
Patch2: rss-glx-0.9.1-debian-readme.patch
Packager: Michael Shigorin <mike@altlinux.org>
# git://git.altlinux.org/people/mike/packages/rss_glx.git

BuildRequires(pre): rpm-build-xscreensaver
%{?_with_kde:BuildRequires(pre): kde-common-devel}

# Automatically added by buildreq on Sun Nov 09 2008 (-bi)
BuildRequires: bzlib-devel gcc-c++ libImageMagick-devel libXt-devel libglew-devel

%description
The Really Slick Screensavers GLX port.
A collection of fancy OpenGL screensavers ported from Windows to X
for use with xscreensaver.

%package -n xscreensaver-hacks-%name
Summary: Really Slick Screensavers - xscreensaver modules
Group: Graphical desktop/Other
Requires: %name = %version-%release
PreReq: xscreensaver >= 4.09-alt1
Provides: xscreensaver-hack

%description -n xscreensaver-hacks-%name
The Really Slick Screensavers GLX port.
A collection of fancy OpenGL screensavers ported from Windows to X
for use with xscreensaver.

This package contains xscreensaver modules configs.

%package kde
Summary: Really Slick Screensavers - KDE modules
Group: Graphical desktop/KDE
Requires: %name = %version-%release
PreReq: kde-common

%description kde
The Really Slick Screensavers GLX port.
A collection of fancy OpenGL screensavers ported from Windows to X
for use with xscreensaver.

This package contains KDE menu entries.

%prep
%setup -n %name-%version-%release
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%autoreconf
%configure \
	--program-prefix=%program_prefix \
	--with-configdir=%xss_conf_dir \
%if_with kde
	--with-kdessconfigdir=%_Kapplnk/System/ScreenSavers \
%endif
	%{subst_enable sound} \
	#
%make_build

# Get xscreensaver config
grep '^\$screensavers' utils/rss-glx_install.pl |
	sed -e 's,^\$screensavers-.*= '\''\(.*\)'\'';,\1,; s,\\\(.\),\1,g; s,\([A-Za-z0-9_-]\+\) --root,%program_prefix\1 --root,' > %name.xss
sed -i 's,%{program_prefix}matrixview --root,& -i %_datadir/%name-matrixvew,' %name.xss

# Fixup KDE desktop files
find . -name '*.desktop' -print0 |
	xargs -r0 sed -i 's,^\(Exec=\),\1%program_prefix,; s,^\(Exec=\)\(%program_prefix\)\(kxs\(config\|run\)\) ,\1\3 \2,;' --

%install
mkdir -p %buildroot%xss_ad_dir
%makeinstall_std
rm -f %buildroot%_bindir/*_install.pl

for i in %buildroot%xss_conf_dir/*.xml; do
	d="${i%%/*}"
	f="${i##*/}"
	mv "$i" "$d/%program_prefix$f"
done

mkdir -p %buildroot%_desktopdir/screensavers

install -pm644 %name.xss %buildroot%xss_ad_dir/%name.xss

%files
%doc COPYING INSTALL README
%_bindir/*
%_man1dir/*

%files -n xscreensaver-hacks-%name
%doc README.xscreensaver
%config %xss_ad_dir/%name.xss
%config %xss_conf_dir/*.xml

%if_with kde
%files kde
%_Kapplnk/System/ScreenSavers/*.desktop
%endif

%changelog
