%define _libexecdir %_prefix/libexec

Name: rtkit
Version: 0.13
Release: alt1
Summary: Realtime Policy and Watchdog Daemon
Group: System/Servers
License: GPLv3+ and BSD
Url: https://github.com/heftig/rtkit

Requires: dbus polkit

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): meson >= 0.49
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(libcap)
BuildRequires: pkgconfig(polkit-gobject-1)
BuildRequires: pkgconfig(libsystemd)
BuildRequires: /usr/bin/xxd

%description
RealtimeKit is a D-Bus system service that changes the
scheduling policy of user processes/threads to SCHED_RR (i.e. realtime
scheduling mode) on request. It is intended to be used as a secure
mechanism to allow real-time scheduling to be used by normal user
processes.

%prep
%setup -q
%patch -p1

%build
%meson \
	-Dsystemd_systemunitdir=%_unitdir \
	-Dinstalled_tests=false

%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=$(pwd)/%{__builddir}/src/shared:$(pwd)/%{__builddir}
%meson_test

%pre
groupadd -r -f rtkit >/dev/null 2>&1 || :
useradd -r -g rtkit -d '/proc' -M -s /sbin/nologin -c "RealtimeKit" rtkit >/dev/null 2>&1 ||:

%post
%post_service rtkit-daemon
dbus-send --system --type=method_call --dest=org.freedesktop.DBus / org.freedesktop.DBus.ReloadConfig >/dev/null 2>&1 || :

%preun
%preun_service rtkit-daemon

%files
%doc README
%_sbindir/%{name}*
%_libexecdir/%name-daemon
%_datadir/dbus-1/system-services/org.freedesktop.RealtimeKit1.service
%_datadir/dbus-1/interfaces/org.freedesktop.RealtimeKit1.xml
%_datadir/dbus-1/system.d/org.freedesktop.RealtimeKit1.conf
%_datadir/polkit-1/actions/org.freedesktop.RealtimeKit1.policy
%_unitdir/rtkit-daemon.service
%_man8dir/*.8*

%changelog
