%define oname freenx-server
%define hooksroot rx-etersoft

Name: rx-etersoft
Version: 1.4.5
Release: alt1

Summary: RX@Etersoft - NX based application/thin-client server

Group: Networking/Remote access
License: GPLv2
Url: http://wiki.etersoft.ru/RX

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: /var/ftp/pvt/Etersoft/RX@Etersoft/%version/source/tarball/%name-%version.tar
Source1: %name.init
Source2: %name.outformat
Source6: sudoers.conf
Source8: nx-terminate-suspend

Obsoletes: freenx
Provides: freenx = %version

Obsoletes: %oname
Provides: %oname = %version

%define NXVERSION 3.5.2
Requires: nx-libs >= 3.5.2
Requires: nxagent

Requires: setxkbmap
Requires: numlockx
Requires: sessreg
Requires: openssl openssh-server openssh-clients
Requires: netcat expect sudo xauth
Requires: zenity
Requires: iconv

Requires: cups cifs-utils

# See eterbug #12003
# Requires: foomatic-db foomatic-db-engine

# for %_libexecdir/cups/backend/smb
# Requires: samba-client

%if %_vendor == "alt"
Requires: dbus-tools-gui
%endif

# _sudoersdir, _cupslibdir
BuildPreReq: rpm-build-intro >= 1.7.25

BuildRequires: imake xorg-cf-files gccmakedep

BuildRequires: expect sudo

AutoReq: yes, nopython

%description
RX@Etersoft (formely freenx-server) is an application/thin-client server based on NX technology.
NoMachine NX is the X compression and roundtrip suppression scheme.
It can operate remote X11 sessions over 56k modem dialup links
or anything better. This package contains a free (GPL) implementation
of the nxserver component.

Recommended Requires: foomatic-db foomatic-db-engine

%prep
%setup
%__subst "s|\$NX_DIR/lib|%_libdir|g" nxloadconfig
# subst version info
%__subst 's|^NX_VERSION=.*|NX_VERSION="%NXVERSION %version-%release"|g' nxloadconfig
%__subst 's|^NX_BACKEND_VERSION=.*|NX_BACKEND_VERSION="%NXVERSION"|g' nxloadconfig

%build
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_bindir/
mkdir -p %buildroot%_var/lib/%name/home/
mkdir -p %buildroot%_var/lib/%name/db/
mkdir -p %buildroot%_sysconfdir/%name/node.conf.d/
mkdir -p %buildroot%_sysconfdir/%name/commands/
mkdir -p %buildroot%_sysconfdir/%name/acls/
mkdir -p %buildroot%_sysconfdir/cron.d/
mkdir -p %buildroot%_datadir/misc/


install -m755 rxsetup %buildroot%_bindir/
install -m755 rxreport %buildroot%_bindir/
install -Dp -m755 %SOURCE1 %buildroot%_initdir/%name
install -Dp -m755 data/fixkeyboard %buildroot%_sysconfdir/%name/fixkeyboard
install -Dp -m755 data/Xsession %buildroot%_sysconfdir/%name/Xsession
install -Dp -m644 data/Xkbmap %buildroot%_sysconfdir/%name/Xkbmap
install -Dp -m400 %SOURCE6 %buildroot%_sudoersdir/rxetersoft
install -Dp -m755 %SOURCE8 %buildroot%_sbindir/nx-terminate-suspend
install -Dp -m644 conf/node.conf %buildroot%_sysconfdir/%name/node.conf
install -m644 conf/conf.d/*.conf %buildroot%_sysconfdir/%name/node.conf.d/
install -m644 conf/acls/* %buildroot%_sysconfdir/%name/acls/
install -m755 commands/* %buildroot%_sysconfdir/%name/commands/

mkdir -p -m755 %buildroot%_sysconfdir/%hooksroot
cp -r hooks %buildroot%_sysconfdir/%hooksroot

mkdir -p -m755 %buildroot%_libdir/%hooksroot
cp -r hooks %buildroot%_libdir/%hooksroot

%if %_vendor != "alt"
install -m755 %SOURCE2 %buildroot%_datadir/misc/
%endif

install -Dp -m644 data/logrotate %buildroot%_sysconfdir/logrotate.d/%name
install -Dp -m644 nx-session-launcher/ConsoleKit-NX.conf %buildroot%_sysconfdir/dbus-1/system.d/ConsoleKit-NX.conf
mv nx-session-launcher/README nx-session-launcher/README.suid

cat >> %buildroot%_sysconfdir/cron.d/%name << EOF
# Terminate suspend sessions if needed
#*/5 * * * *       root    %_sbindir/nx-terminate-suspend
EOF

%pre
%groupadd nx 2>/dev/null ||:
%useradd -g nx -G utmp -d /var/lib/%name/home/ -s %_bindir/nxserver \
        -c "NX System User" nx 2>/dev/null ||:

# Obsoleted (moved to conf.d/07-misc.conf)
# rename config if updated
if [ -r %_sysconfdir/sysconfig/%oname ] && [ ! -r %_sysconfdir/sysconfig/%name ] ; then
    mv -vf %_sysconfdir/sysconfig/%oname %_sysconfdir/sysconfig/%name
fi

%files
%doc AUTHORS CONTRIB nx-session-launcher/README.suid
%dir %_sysconfdir/%name/
%dir %_sysconfdir/%name/node.conf.d/
%dir %_sysconfdir/%name/acls/
%dir %_sysconfdir/%name/commands/
%config(noreplace) %_sysconfdir/%name/node.conf
%config(noreplace) %_sysconfdir/%name/node.conf.d/*
%config(noreplace) %_sysconfdir/%name/acls/*
%attr (0755,root,root) %config(noreplace) %_sysconfdir/%name/commands/*
%config(noreplace) %_sysconfdir/logrotate.d/%name
%attr(0400,root,root) %config(noreplace) %_sudoersdir/rxetersoft
%config(noreplace) %_sysconfdir/dbus-1/system.d/ConsoleKit-NX.conf
%config(noreplace) %_sysconfdir/%name/Xkbmap
%_sysconfdir/%name/fixkeyboard
%_sysconfdir/%name/Xsession
%dir %_sysconfdir/%hooksroot/hooks/
%_sysconfdir/%hooksroot/hooks/*
%dir %_libdir/%hooksroot/hooks/
%_libdir/%hooksroot/hooks/*
%attr(0400,root,root) %config(noreplace) %_sysconfdir/cron.d/%name
%_sbindir/nx-terminate-suspend
%_initddir/%name
%if %_vendor != "alt"
%_datadir/misc/%name.outformat
%endif

#%_bindir/nx-session-launcher
#%attr(4711,nx,root) %_bindir/nx-session-launcher-suid
%_bindir/nxacl.app
%_bindir/nxacl.sample
%_bindir/nxcheckload
%_bindir/nxcups-gethost
%_bindir/nxdesktop_helper
%_bindir/nxdialog
%_bindir/nxkeygen
%_bindir/nxloadconfig
%_bindir/nxnode
%_bindir/nxnode-login
%_bindir/nxpasswd
%_bindir/nxprint
%_bindir/nxredir
%_bindir/cupsredir
%_bindir/nxserver
%_bindir/nxserver-helper
%_bindir/nxserver-suid
%_bindir/nxserver-usermode
%_bindir/nxsetup
%_bindir/nxviewer_helper
%_bindir/rxsetup
%_bindir/rxreport
%dir %_libdir/%name/
%attr(755,root,root) %_libdir/%name/libnxredir.so.0
%attr(755,root,root) %_libdir/%name/libcupsredir.so.0
%_cupslibdir/backend/nx*
%dir %_var/lib/%name/
%attr(2750,nx,nx) %_var/lib/%name/home/
%attr(2750,root,nx) %_var/lib/%name/db/

%changelog
