%def_enable snapshot
# [150/151] Linking target pgp/hkp-source
# hasher-priv: master: idle time limit (3600 seconds) exceeded
%{?optflags_lto:%global optflags_lto %nil}

%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define ver_major 40
%define xdg_name org.gnome.seahorse

%def_disable debug
%def_enable ldap
%def_enable hkp
%def_enable gnome_keyring
%def_enable pkcs11
%def_enable ssh
%def_enable introspection
%def_enable man

%if_enabled hkp
%def_enable sharing
%endif

Name: seahorse
Version: %ver_major.0
Release: alt3

Summary: A password and encryption key manager
License: GPL-2.0 and LGPL-2.1
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Seahorse

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
#https://bugzilla.altlinux.org/show_bug.cgi?id=37650
Source1: %name.ru.po

%define glib_ver 2.58
%define gtk_ver 3.24
%define soup_ver 2.34
%define secret_ver 0.16
%define avahi_ver 0.6
%define gcr_ver 3.38
%define gpgme_ver 1.7
%define handy_ver 1.1
%define gnupg_ver 2.2.0

Requires: dconf
Requires: gnupg2 > %gnupg_ver gcr >= %gcr_ver
Requires: pinentry-x11
%{?_enable_ssh:Requires: openssh-clients}
%{?_enable_sharing:Requires: avahi-daemon}

BuildRequires(pre): meson rpm-build-gnome rpm-build-licenses
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: gtk-doc desktop-file-utils
BuildRequires: gcc-c++ glib2-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: gnupg2 >= %gnupg_ver
BuildRequires: libgpgme-devel >= %gpgme_ver
BuildRequires: libgpg-error-devel
BuildRequires: vala-tools
BuildRequires: pkgconfig(pwquality)
%{?_enable_ldap:BuildRequires: libldap-devel}
%{?_enable_hkp:BuildRequires: libsoup-devel >= %soup_ver}
%{?_enable_gnome_keyring:BuildRequires: libsecret-devel >= %secret_ver}
%{?_enable_pkcs11:BuildRequires: gcr-libs-devel >= %gcr_ver gcr-libs-vala}
%{?_enable_sharing:BuildRequires: libavahi-glib-devel >= %avahi_ver libavahi-devel }
%{?_enable_ssh:BuildRequires: openssh openssh-clients}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

%description
Seahorse is a password and encryption key manager for GNOME desktop.

%prep
%setup
#cp %SOURCE1 po/ru.po

%build
%meson \
%{?_disable_ldap:-Dldap-support=false} \
%{?_disable_pkcs11:-Dpkcs11-support=false} \
%{?_disable_hkp:-Dhkp-support=false} \
%{?_disable_sharing:-Dkey-sharing=false} \
%{?_enable_man:-Dmanpage=true}
%nil
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ssh-askpass
%_libexecdir/%name/xloadimage
%dir %_datadir/%name
%_datadir/%name/*
%_iconsdir/hicolor/*/*/*.*
%_desktopdir/*.desktop
%{?_enable_man:%_man1dir/*}
%_datadir/dbus-1/services/org.gnome.seahorse.Application.service
%_datadir/gnome-shell/search-providers/seahorse-search-provider.ini
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.manager.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.window.gschema.xml
%_datadir/metainfo/%{xdg_name}*.appdata.xml
%doc AUTHORS NEWS README* THANKS

%changelog
