%def_disable snapshot
%define ver_major 40
%define beta %nil
%define xdg_name org.gnome.SimpleScan

%def_enable packagekit

Name: simple-scan
Version: %ver_major.6
Release: alt1%beta

Summary: Simple scanning utility
License: GPL-3.0-or-later
Group: Graphics
Url: http://launchpad.net/%name

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: simple-scan-40.5-alt-fix_PageSide_schema.patch

Requires: sane xdg-utils gnome-icon-theme colord
%{?_enable_packagekit:Requires: packagekit}

%define gtk_ver 3.22
%define gusb_ver 0.2.7
%define handy_ver 1.1.90

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver libgusb-devel >= %gusb_ver
BuildRequires: libsane-devel zlib-devel
BuildRequires: vala-tools libcolord-vala
BuildRequires: libcolord-devel libwebp-devel
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
%{?_enable_packagekit:BuildRequires: libpackagekit-glib-devel}

%description
Simple Scan is an easy-to-use application, designed to let users connect their
scanner and quickly have the image/document in an appropriate format.

%prep
%setup -n %name-%version%beta
%patch -p1 -b .pageside

%build
%meson %{?_disable_packagekit:-Dpackagekit=false}
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%name.appdata.xml
%_man1dir/*

%changelog
