Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install python3-module-setuptools
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: slingshot
Version:  0.9
Release:  alt2_12
Summary: A Newtonian strategy game

License: GPLv2+        
URL: https://github.com/ryanakca/slingshot
Source0: https://github.com/ryanakca/slingshot/archive/%{version}/slingshot-%{version}.tar.gz
Source1: slingshot.desktop
Source2: slingshot.appdata.xml
# Port to Python 3
Patch0: 243aef95dde390f97f1e0abbbdb646b3e5b97f7d.patch
BuildArch: noarch
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: python3-devel
BuildRequires: python3-module-distribute
Requires: fonts-ttf-gnu-freefont-sans
Requires: icon-theme-hicolor
Requires: python3-module-pygame
Source44: import.info

%description
Slingshot is a two dimensional, turn based simulation-strategy game 
set in the gravity fields of several planets. It is a highly 
addictive game, and never the same from round to round due to its 
randomly generated playing fields.

%prep
%setup -q
%patch0 -p1

rm -f src/slingshot/data/FreeSansBold.ttf

%build
%python3_build

%install
%python3_install

rm -rf $RPM_BUILD_ROOT/slingshot
rm -rf $RPM_BUILD_ROOT/home
rm -rf $RPM_BUILD_ROOT/builddir

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications \
  %{SOURCE1}

mv src/slingshot/data/icon64x64.png src/slingshot/data/slingshot.png

mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
install -p -m 644 src/slingshot/data/slingshot.png \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps

#install appdata
mkdir -p $RPM_BUILD_ROOT/%{_metainfodir}
install -p -m 664 %{SOURCE2} $RPM_BUILD_ROOT/%{_metainfodir}
appstream-util validate-relax --nonet $RPM_BUILD_ROOT/%{_metainfodir}/*.appdata.xml

#Link to font
ln -s %{_datadir}/fonts/ttf/gnu-free/FreeSansBold.ttf $RPM_BUILD_ROOT%{python3_sitelibdir_noarch}/%{name}/data/FreeSansBold.ttf

%files
%{_bindir}/slingshot
%{python3_sitelibdir_noarch}/%{name}-*.egg-info
%{python3_sitelibdir_noarch}/%{name}/
%doc README
%doc --no-dereference LICENSE
%{_datadir}/applications/slingshot.desktop
%{_datadir}/icons/hicolor/64x64/apps/slingshot.png
%{_metainfodir}/slingshot.appdata.xml

%changelog
