Name: slocate
Version: 0.2.16
Release: alt2
Epoch: 1

Summary: Finds files on a system via central file name database
License: GPLv2+
Group: File tools
Packager: Dmitry V. Levin <ldv@altlinux.org>

Source: slocate-%version.tar

BuildRequires: libcap-devel

%description
This is a security-enhanced version of locate.  Just like locate, slocate
searches through a central database (which is usually updated nightly)
for files which match a given pattern.  Locate allows you to quickly
find files anywhere on your system.

%prep
%setup -q

%build
%make_build CFLAGS="%optflags"

%install
make install DESTDIR=%buildroot
install -pD -m644 /dev/null %buildroot%_localstatedir/locate/locatedb

%pre
/usr/sbin/groupadd -r -f %name
/usr/sbin/useradd -r -g %name -d /dev/null -s /dev/null -n %name >/dev/null 2>&1 ||:

%files
%attr(2711,root,%name) %_bindir/%name
%_bindir/locate
%_sbindir/*
%config %_sysconfdir/cron.daily/*
%config(noreplace) %_sysconfdir/*.conf
%_mandir/man?/*
%attr(710,root,%name) %dir %_localstatedir/locate
%attr(640,root,%name) %verify(not md5 mtime size) %ghost %_localstatedir/locate/locatedb

%changelog
