Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# empty debuginfo
%global debug_package %nil

Name:             snappy-java
Version:          1.1.2.4
Release:          alt2_19jpp11
Summary:          Fast compressor/decompresser
License:          ASL 2.0
URL:              http://xerial.org/snappy-java/

# set Version, run ./gen_clean_tarball.sh
Source0:          snappy-java-%{version}-clean.tar.gz

# Not able to build snappy-java jni library with sbt:
# use sbt = 0.13.8 (use scala 2.11.6) available 0.13.1 (use scala 2.10.4)
# Too many missing plugins:
# com.etsy:sbt-checkstyle-plugin:0.4.3
# com.github.gseitz:sbt-release:1.0.0
# com.jsuereth:sbt-pgp:1.0.0
# com.typesafe.sbt:sbt-osgi:0.7.0
# de.johoop:findbugs4sbt:1.4.0
# de.johoop:jacoco4sbt:2.1.5
# org.xerial.sbt:sbt-sonatype:0.5.0
Source1:          http://central.maven.org/maven2/org/xerial/snappy/%{name}/%{version}/%{name}-%{version}.pom

Patch0:           snappy-java-1.1.2-build.patch
Patch1:           snappy-java-1.1.2.4-lsnappy.patch

# Use "javac -h" because "javah" command disappeared in java 11
Patch2:           javah-adaptation.patch

BuildRequires:    gcc-c++
BuildRequires:    libstdc++-devel-static
BuildRequires:    libsnappy-devel

BuildRequires:    maven-local
BuildRequires:    mvn(com.sun:tools)
BuildRequires:    mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:    mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires:    mvn(org.osgi:osgi.core)

Requires:         libsnappy
Source44: import.info

%description
A Java port of the snappy, a fast compresser/decompresser written in C++.

%package javadoc
Group: Development/Java
Summary:          Javadoc for %{name}
BuildArch:        noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q
# Cleanup
find -name "*.class" -print -delete
find -name "*.jar" -print -delete
rm -r ./*sbt* project

# Remove prebuilt libraries
find -name "*.jnilib" -print -delete
find -name "*.dll" -print -delete
find -name "*.so" -print -delete
find -name "*.a" -print -delete
find -name "*.h" -print -delete

%patch0 -p1
%patch1 -p1
%patch2

cp %{SOURCE1} pom.xml
%pom_xpath_remove "pom:dependency[pom:scope = 'test']"

# use osgi-core instead of felix-osgi-core
%pom_change_dep :org.osgi.core org.osgi:osgi.core

# Build JNI library
%pom_add_plugin org.apache.maven.plugins:maven-antrun-plugin . '
<dependencies>
 <dependency>
  <groupId>com.sun</groupId>
  <artifactId>tools</artifactId>
  <version>1.8.0</version>
 </dependency>
</dependencies>

<executions>
  <execution>
  <id>compile</id>
  <phase>process-classes</phase>
    <configuration>
      <target>
       <javac destdir="lib"
         srcdir="src/main/java"
         source="${maven.compiler.source}" target="${maven.compiler.target}" debug="on"
         classpathref="maven.plugin.classpath">
         <include name="**/OSInfo.java"/>
       </javac>
       <exec executable="make" failonerror="true">
       </exec>
      </target>
    </configuration>
    <goals>
      <goal>run</goal>
    </goals>
  </execution>
</executions>'
# Add OSGi support
%pom_add_plugin org.apache.felix:maven-bundle-plugin:2.5.4 . '
<extensions>true</extensions>
<configuration>
  <instructions>
    <Bundle-Activator>org.xerial.snappy.SnappyBundleActivator</Bundle-Activator>
    <Bundle-ActivationPolicy>lazy</Bundle-ActivationPolicy>
    <Bundle-SymbolicName>${project.groupId}.${project.artifactId}</Bundle-SymbolicName>
    <Bundle-Version>${project.version}</Bundle-Version>
    <Import-Package>org.osgi.framework,*</Import-Package>
  </instructions>
</configuration>
<executions>
  <execution>
    <id>bundle-manifest</id>
    <phase>process-classes</phase>
    <goals>
      <goal>manifest</goal>
    </goals>
  </execution>
</executions>'

chmod 644 NOTICE README.md
# Convert from dos to unix line ending
for file in LICENSE NOTICE README.md; do
 sed -i.orig 's|\r||g' $file
 touch -r $file.orig $file
 rm $file.orig
done

%build

CXXFLAGS="${CXXFLAGS:-%optflags}"
export CXXFLAGS
# No test deps available:
#    org.xerial.java:xerial-core:2.1
#    org.xerial:xerial-core:3.2.3
#    org.scalatest:scalatest_2.11:2.2.0
#    com.novocode:junit-interface:0.10
%mvn_build -f -- -Dproject.build.sourceEncoding=UTF-8 -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc README.md
%doc --no-dereference LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%changelog
