Name: socat
Version: 1.7.4.1
Release: alt1

Summary: 'socket cat' - multipurpose relay for bidirectional data transfer
License: GPLv2
Group: Networking/Other
Url: http://www.dest-unreach.org/socat/
Source: %name-%version.tar.gz

BuildRequires: libe2fs-devel libreadline-devel libssl-devel

%description
socat is a relay for bidirectional data transfer between two independent
data channels. Each of these data channels may be a file, pipe, device
(serial line etc. or a pseudo terminal), a socket (UNIX, IP4, IP6 - raw,
UDP, TCP), an SSL socket, proxy CONNECT connection, a file descriptor
(stdin etc.), the GNU line editor (readline), a program, or a
combination of two of these.  These modes include generation of
"listening" sockets, named pipes, and pseudo terminals.

%prep
%setup
iconv -f iso8859-1 -t utf8 < CHANGES > CHANGES.utf8
mv CHANGES.utf8 CHANGES
find -maxdepth 1 -type f -print0 |
	xargs -r0 grep -FZl linux/ext2_fs.h -- |
	xargs -r0 sed -i 's,linux/ext2_fs\.h,ext2fs/ext2_fs.h,g' --
find -maxdepth 1 -type f -print0 |
	xargs -r0 grep -FZl HAVE_LINUX_EXT2_FS_H -- |
	xargs -r0 sed -i 's,HAVE_LINUX_EXT2_FS_H,HAVE_EXT2FS_EXT2_FS_H,g' --

%build
%add_optflags -fno-strict-aliasing
%configure
for n in HAVE_DEV_PTMX HAVE_PROC_DIR_FD; do
	sed -i "/$n/ s/.*/#define $n 1/" config.h
done
%make_build

%install
%makeinstall_std
ln -s socat.1 %buildroot%_man1dir/filan.1
ln -s socat.1 %buildroot%_man1dir/procan.1

%files
%_bindir/filan
%_bindir/procan
%_bindir/socat
%_man1dir/*
%doc doc/*.html doc/*.css
%doc BUGREPORTS CHANGES EXAMPLES FAQ README SECURITY

%changelog
