%def_enable snapshot
%define _unpackaged_files_terminate_build 1

%define ver_major 3.38
%define gst_api_ver 1.0
%define xdg_name org.gnome.SoundJuicer

Name: sound-juicer
Version: %ver_major.0
Release: alt2

Summary: Clean and lean CD ripper
Group: Sound
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/SoundJuicer

Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver
Requires: iso-codes

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: %name-3.38.0-alt-help_build.patch

%define glib_ver 2.50
%define gtk_ver 3.22
%define musicbrainz_ver 5.1.0
%define diskid_ver 0.4.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libbrasero-devel >= 3.0.0
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libcanberra-devel libcanberra-gtk3-devel
BuildRequires: gst-plugins%gst_api_ver-devel %_bindir/gst-inspect-%gst_api_ver
BuildRequires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver
BuildRequires: libmusicbrainz5-devel >= %musicbrainz_ver libdiscid-devel >= %diskid_ver iso-codes-devel

%description
GStreamer-based CD ripping tool. Saves audio CDs to audio formats,
supported by GStreamer.

%prep
%setup
%patch -p1 -b .help

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=DiscBurning \
	--add-category=GTK \
	%buildroot%_desktopdir/%xdg_name.desktop

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/icons/*/*/*/*
%_datadir/GConf/gsettings/%name.convert
%_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc AUTHORS README* NEWS

%exclude %_datadir/doc/%name/

%changelog
