%define spawn_fcgi_user _spawn_fcgi
%define spawn_fcgi_group _spawn_fcgi

Name: spawn-fcgi
Version: 1.6.4
Release: alt4

Summary: spawn FastCGI applications
License: BSD
Group: System/Servers

# git remote add upstream git://git.lighttpd.net/spawn-fcgi
Url: http://redmine.lighttpd.net/projects/spawn-fcgi/wiki

Source0: %name-%version.tar
Patch0: %name-%version-alt.patch

%description
  spawn-fcgi is used to spawn FastCGI applications

  Features
  --------
  - binds to IPv4/IPv6 and Unix domain sockets
  - supports privilege separation: chmod/chown socket, drop to uid/gid
  - supports chroot
  - supports daemontools supervise

%prep
%setup
%patch0 -p1
%autoreconf

%build
%configure
%make_build

%install
%makeinstall

mkdir -p %buildroot%_var/run/spawn-fcgi
install -pDm755 altlinux/spawn-fcgi.init %buildroot%_initdir/spawn-fcgi
install -pDm644 altlinux/spawn-fcgi.sysconfig %buildroot%_sysconfdir/sysconfig/spawn-fcgi

%pre
%_sbindir/groupadd -r -f %spawn_fcgi_group ||:
%_sbindir/useradd -r -g %spawn_fcgi_group -d /dev/null -s /dev/null -n %spawn_fcgi_user \
        2> /dev/null > /dev/null ||:

%post
%post_service spawn-fcgi

%preun
%preun_service spawn-fcgi

%files
%_bindir/spawn-fcgi
%_man1dir/spawn-fcgi*
%config(noreplace) %_sysconfdir/sysconfig/spawn-fcgi
%_initdir/spawn-fcgi
%dir %attr(1770,root,%spawn_fcgi_group) %_var/run/spawn-fcgi

%changelog
