Name: spdlog
Version: 1.11.0
Release: alt0.p10.1

Summary: Super fast C++ logging library

Group: Development/Other
License: MIT
Url: https://github.com/gabime/spdlog

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/gabime/%name/archive/v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: ctest
BuildRequires: gcc-c++
BuildRequires: libbenchmark-devel libfmt-devel

%description
This is a packaged version of the gabime/spdlog header-only C++
logging library available at Github.

%package -n lib%name
Summary: Super fast C++ logging library
Group: Development/C++

%description -n lib%name
This is a packaged version of the gabime/spdlog header-only C++
logging library available at Github.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/Other
Requires: lib%name = %EVR

%description -n lib%name-devel
The %name-devel package contains C++ header files for developing
applications that use %name.

%prep
%setup
rm -rfv include/spdlog/fmt/bundled/

%build
%cmake -DSPDLOG_BUILD_SHARED=ON \
       -DSPDLOG_FMT_EXTERNAL=ON \
       -DSPDLOG_BUILD_TESTS=ON
%cmake_build

%install
%cmake_install
# enable external libfmt using
%__subst "s|// #define SPDLOG_FMT_EXTERNAL|#define SPDLOG_FMT_EXTERNAL|" %buildroot%_includedir/spdlog/tweakme.h

%check
export LD_LIBRARY_PATH=$(pwd)/%_cmake__builddir
%cmake_build --target test

%files -n lib%name
%_libdir/libspdlog.so.*

%files -n lib%name-devel
%doc README.md example/
%doc LICENSE
%_includedir/spdlog/
%_libdir/libspdlog.so
%_libdir/cmake/spdlog
%_pkgconfigdir/*.pc

%changelog
