%define _unpackaged_files_terminate_build 1
%define _runtimedir /run
%define _localstatedir /var
#Use GTK+ instead of Xlib
%def_with gtk

Name: spice-vdagent
Version: 0.22.1
Release: alt1.1
Epoch: 1
Summary: Agent for Spice guests
Group: Networking/Remote access
License: GPLv3+
Url: http://spice-space.org/

# VCS-git: https://gitlab.freedesktop.org/spice/linux/vd_agent.git
Source: %name-%version.tar
Source2: spice-vdagentd.init-alt
Patch: %name-%version.patch

BuildRequires(pre): rpm-macros-systemd
BuildRequires: pkgconfig(gio-unix-2.0) >= 2.50
%{?_with_gtk:BuildRequires: pkgconfig(gtk+-3.0) >= 3.22}
BuildRequires: pkgconfig(xfixes) pkgconfig(xrandr) >= 1.3 pkgconfig(xinerama) pkgconfig(x11)
BuildRequires: pkgconfig(spice-protocol) >= 0.14.3
BuildRequires: pkgconfig(alsa) >= 1.0.22
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(pciaccess) >= 0.10
BuildRequires: desktop-file-utils
BuildRequires: pkgconfig(systemd) pkgconfig(libsystemd) >= 209
BuildRequires: pkgconfig(udev)
BuildRequires: desktop-file-utils

%description
Spice agent for Linux guests offering the following features:

Features:
* Client mouse mode (no need to grab mouse by client, no mouse lag)
  this is handled by the daemon by feeding mouse events into the kernel
  via uinput. This will only work if the active X-session is running a
  spice-vdagent process so that its resolution can be determined.
* Automatic adjustment of the X-session resolution to the client resolution
* Support of copy and paste (text and images) between the active X-session
  and the client

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
    %{subst_with gtk} \
	--with-session-info=auto \
	--with-init-script=systemd+redhat

%make_build

%install
%makeinstall_std
install -m 0755 %SOURCE2 %buildroot%_initdir/spice-vdagentd

# fix autostart in KDE Plasma
cp -ar %buildroot/%_sysconfdir/xdg/autostart/spice-vdagent{,-kde}.desktop
desktop-file-install --mode=0644 --dir %buildroot/%_sysconfdir/xdg/autostart \
	--add-not-show-in="KDE" \
	%buildroot/%_sysconfdir/xdg/autostart/spice-vdagent.desktop
desktop-file-install --mode=0644 --dir %buildroot/%_sysconfdir/xdg/autostart \
	--add-only-show-in="KDE" \
	--remove-key="X-GNOME-Autostart-Phase" \
	--set-key="Exec" --set-value="/usr/bin/spice-vdagent -x" \
	%buildroot/%_sysconfdir/xdg/autostart/spice-vdagent-kde.desktop

%post
%post_service spice-vdagentd
%systemd_user_post spice-vdagent.service

%preun
%preun_service spice-vdagentd
%systemd_user_preun spice-vdagent.service

%files
%doc COPYING CHANGELOG.md README.md
/lib/udev/rules.d/*.rules
/lib/tmpfiles.d/spice-vdagentd.conf
%_initddir/spice-vdagentd
%_unitdir/*
%_userunitdir/*
%_bindir/spice-vdagent
%_sbindir/spice-vdagentd
%_sysconfdir/xdg/autostart/spice-vdagent*.desktop
%_datadir/gdm/autostart/LoginWindow/spice-vdagent.desktop
%_datadir/gdm/greeter/autostart/spice-vdagent.desktop
%_man1dir/*

%changelog
