%define _unpackaged_files_terminate_build 1

%def_enable debug

Name: springrts
Version: 105.0
Release: alt1.1

Summary: Real time strategy game engine with many mods
License: GPL-2.0+ and BSD-3-Clause
Group: Games/Strategy
Url: https://springrts.com/

ExclusiveArch: %ix86 x86_64

# https://github.com/spring/spring.git
Source: %name-%version.tar

# submodules
Source1: %name-%version-AI-Interfaces-Python.tar
Source2: %name-%version-AI-Skirmish-AAI.tar
Source3: %name-%version-AI-Skirmish-CircuitAI.tar
Source4: %name-%version-AI-Skirmish-HughAI.tar
Source5: %name-%version-AI-Skirmish-KAIK.tar
Source6: %name-%version-AI-Skirmish-Shard.tar
Source7: %name-%version-tools-mapcompile.tar
Source8: %name-%version-tools-pr-downloader.tar
Source9: %name-%version-tools-pr-downloader-src-lib-libgit2.tar
Source10: %name-%version-tools-unitsync-python.tar

Patch1: %name-alt-linking.patch
Patch2: %name-alt-unbundle-libs.patch
Patch3: %name-alt-unbundle-libs-pr-downloader.patch

BuildRequires(pre): rpm-build-xdg rpm-macros-cmake
BuildRequires: cmake cmake-modules java-devel /proc libGL-devel libGLU-devel gcc-c++
BuildRequires: boost-devel boost-program_options-devel boost-asio-devel boost-signals-devel boost-filesystem-devel
BuildRequires: libICE-devel libSM-devel libX11-devel libXdamage-devel libXfixes-devel libXrender-devel 
BuildRequires: libXt-devel libfreetype-devel libogg-devel libstdc++-devel 
BuildRequires: xorg-inputproto-devel xorg-kbproto-devel xorg-xextproto-devel xorg-xf86miscproto-devel 
BuildRequires: xorg-xineramaproto-devel xorg-xproto-devel zlib-devel p7zip libXcursor-devel
BuildRequires: libdevil-devel libfreeglut-devel libglew-devel libopenal1-devel 
BuildRequires: libvorbis-devel  python-devel libSDL2-devel
BuildRequires: docbook5-style-xsl asciidoc libminizip-devel
BuildRequires: libXres-devel libXtst-devel libXau-devel libXcomposite-devel
BuildRequires: libXdmcp-devel libXext-devel libXft-devel libXi-devel
BuildRequires: libXinerama-devel libxkbfile-devel libXmu-devel libXpm-devel
BuildRequires: libXrandr-devel libXScrnSaver-devel libXv-devel
BuildRequires: libXxf86misc-devel libXxf86vm-devel
BuildRequires: libcurl-devel jsoncpp-devel libunwind-devel
BuildRequires: /usr/bin/xsltproc
BuildRequires: asio-devel libassimp-devel

Requires: %name-data = %EVR
Conflicts: %name-dedicated < %EVR
Provides: %name-dedicated = %EVR
Obsoletes: %name-dedicated

%description
Spring is an open source RTS (Real time Strategy) engine originally
designed to recreate the experience of Total Annihilation.  Spring now
supports many different games ("mods"), including both remakes of the
original Total Annihilation and completely new games.

This package contains the game engine and default AI, but no maps, mods,
or user interface.

%package data
Summary: data files for Spring RTS engine
Group: Games/Strategy
BuildArch: noarch

%description data
data files for Spring RTS engine

%prep
%setup -a1 -a2 -a3 -a4 -a5 -a6 -a7 -a8 -a9 -a10
%patch1 -p1
%patch2 -p1

pushd tools/pr-downloader
%patch3 -p1
popd

# TODO: remove remaining bundled libraries. They're either missing or patched.
rm -rf tools/pr-downloader/src/lib/{jsoncpp,minizip}
rm -rf rts/lib/{asio,assimp,minizip}

# provide version information
echo %version > VERSION

%build
%add_optflags -fPIC -DPIC -D_FILE_OFFSET_BITS=64
%cmake \
%if_enabled debug
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
%else
	-DCMAKE_BUILD_TYPE=Release \
%endif
	-DLIBDIR=%_libdir \
	-DBINDIR=%_gamesbindir \
	-DAI_LIBS_DIR=%_libdir/spring \
	-DAI_DATA_DIR=%_gamesdatadir/spring \
	-DDOCDIR=share/doc/%name-%version \
	-DDOCBOOK_XSL=%_datadir/sgml/docbook/xsl-ns-stylesheets/manpages/docbook.xsl \
	-DAI_TYPES=NATIVE \
	%nil

%cmake_build

%install
%cmake_install

# Move icons into proper Freedesktop hicolor theme
mkdir -p %buildroot%_liconsdir

mv %buildroot%_pixmapsdir/spring.png \
    %buildroot%_liconsdir/

mkdir -p %buildroot%_iconsdir/hicolor/48x48/mimetypes/

mv %buildroot%_pixmapsdir/application-x-spring-demo.png \
    %buildroot%_iconsdir/hicolor/48x48/mimetypes/

# Make it visible
sed -i -e '/NoDisplay=true/d' \
    %buildroot%_desktopdir/spring.desktop

%files
%doc LICENSE LICENSE.html
%doc AUTHORS FAQ THANKS
%_gamesbindir/pr-downloader
%_gamesbindir/spring
%_gamesbindir/spring-headless
%_gamesbindir/spring-dedicated
%_gamesbindir/mapcompile
%_gamesbindir/mapdecompile
%_libdir/spring
%_libdir/*.so

%files data
%_gamesdatadir/*
%_xdgmimedir/packages/*
%_desktopdir/*
%_liconsdir/*
%_iconsdir/hicolor/*/mimetypes/*.png
%_man6dir/*

%changelog
